@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.kotlin.outputs.EndpointAccessVpcEndpoint
import com.pulumi.aws.redshift.kotlin.outputs.EndpointAccessVpcEndpoint.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [EndpointAccess].
 */
@PulumiTagMarker
public class EndpointAccessResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointAccessArgs = EndpointAccessArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointAccessArgsBuilder.() -> Unit) {
        val builder = EndpointAccessArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EndpointAccess {
        val builtJavaResource = com.pulumi.aws.redshift.EndpointAccess(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EndpointAccess(builtJavaResource)
    }
}

/**
 * Creates a new Amazon Redshift endpoint access.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.EndpointAccess;
 * import com.pulumi.aws.redshift.EndpointAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EndpointAccess("example", EndpointAccessArgs.builder()
 *             .endpointName("example")
 *             .subnetGroupName(aws_redshift_subnet_group.example().id())
 *             .clusterIdentifier(aws_redshift_cluster.example().cluster_identifier())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift endpoint access using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/endpointAccess:EndpointAccess example example
 * ```
 *
 */
public class EndpointAccess internal constructor(
    override val javaResource: com.pulumi.aws.redshift.EndpointAccess,
) : KotlinCustomResource(javaResource, EndpointAccessMapper) {
    /**
     * The DNS address of the endpoint.
     */
    public val address: Output<String>
        get() = javaResource.address().applyValue({ args0 -> args0 })

    /**
     * The cluster identifier of the cluster to access.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * The Redshift-managed VPC endpoint name.
     */
    public val endpointName: Output<String>
        get() = javaResource.endpointName().applyValue({ args0 -> args0 })

    /**
     * The port number on which the cluster accepts incoming connections.
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
     */
    public val resourceOwner: Output<String>
        get() = javaResource.resourceOwner().applyValue({ args0 -> args0 })

    /**
     * The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
     */
    public val subnetGroupName: Output<String>
        get() = javaResource.subnetGroupName().applyValue({ args0 -> args0 })

    /**
     * The connection endpoint for connecting to an Amazon Redshift cluster through the proxy. See details below.
     */
    public val vpcEndpoints: Output<List<EndpointAccessVpcEndpoint>>
        get() = javaResource.vpcEndpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
     */
    public val vpcSecurityGroupIds: Output<List<String>>
        get() = javaResource.vpcSecurityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object EndpointAccessMapper : ResourceMapper<EndpointAccess> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.EndpointAccess::class == javaResource::class

    override fun map(javaResource: Resource): EndpointAccess = EndpointAccess(
        javaResource as
            com.pulumi.aws.redshift.EndpointAccess,
    )
}

/**
 * @see [EndpointAccess].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EndpointAccess].
 */
public suspend fun endpointAccess(
    name: String,
    block: suspend EndpointAccessResourceBuilder.() -> Unit,
): EndpointAccess {
    val builder = EndpointAccessResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EndpointAccess].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpointAccess(name: String): EndpointAccess {
    val builder = EndpointAccessResourceBuilder()
    builder.name(name)
    return builder.build()
}
