@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [HsmClientCertificate].
 */
@PulumiTagMarker
public class HsmClientCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HsmClientCertificateArgs = HsmClientCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HsmClientCertificateArgsBuilder.() -> Unit) {
        val builder = HsmClientCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HsmClientCertificate {
        val builtJavaResource = com.pulumi.aws.redshift.HsmClientCertificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HsmClientCertificate(builtJavaResource)
    }
}

/**
 * Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client's HSM in order to store and retrieve the keys used to encrypt the cluster databases.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.HsmClientCertificate;
 * import com.pulumi.aws.redshift.HsmClientCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HsmClientCertificate("example", HsmClientCertificateArgs.builder()
 *             .hsmClientCertificateIdentifier("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift HSM Client Certificates using `hsm_client_certificate_identifier`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/hsmClientCertificate:HsmClientCertificate test example
 * ```
 *
 */
public class HsmClientCertificate internal constructor(
    override val javaResource: com.pulumi.aws.redshift.HsmClientCertificate,
) : KotlinCustomResource(javaResource, HsmClientCertificateMapper) {
    /**
     * Amazon Resource Name (ARN) of the Hsm Client Certificate.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The identifier of the HSM client certificate.
     */
    public val hsmClientCertificateIdentifier: Output<String>
        get() = javaResource.hsmClientCertificateIdentifier().applyValue({ args0 -> args0 })

    /**
     * The public key that the Amazon Redshift cluster will use to connect to the HSM. You must register the public key in the HSM.
     */
    public val hsmClientCertificatePublicKey: Output<String>
        get() = javaResource.hsmClientCertificatePublicKey().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object HsmClientCertificateMapper : ResourceMapper<HsmClientCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.HsmClientCertificate::class == javaResource::class

    override fun map(javaResource: Resource): HsmClientCertificate = HsmClientCertificate(
        javaResource
            as com.pulumi.aws.redshift.HsmClientCertificate,
    )
}

/**
 * @see [HsmClientCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HsmClientCertificate].
 */
public suspend fun hsmClientCertificate(
    name: String,
    block: suspend HsmClientCertificateResourceBuilder.() -> Unit,
): HsmClientCertificate {
    val builder = HsmClientCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HsmClientCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hsmClientCertificate(name: String): HsmClientCertificate {
    val builder = HsmClientCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
