@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.HsmClientCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client's HSM in order to store and retrieve the keys used to encrypt the cluster databases.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.HsmClientCertificate;
 * import com.pulumi.aws.redshift.HsmClientCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HsmClientCertificate("example", HsmClientCertificateArgs.builder()
 *             .hsmClientCertificateIdentifier("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift HSM Client Certificates using `hsm_client_certificate_identifier`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/hsmClientCertificate:HsmClientCertificate test example
 * ```
 * @property hsmClientCertificateIdentifier The identifier of the HSM client certificate.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class HsmClientCertificateArgs(
    public val hsmClientCertificateIdentifier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.HsmClientCertificateArgs> {
    override fun toJava(): com.pulumi.aws.redshift.HsmClientCertificateArgs =
        com.pulumi.aws.redshift.HsmClientCertificateArgs.builder()
            .hsmClientCertificateIdentifier(hsmClientCertificateIdentifier?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [HsmClientCertificateArgs].
 */
@PulumiTagMarker
public class HsmClientCertificateArgsBuilder internal constructor() {
    private var hsmClientCertificateIdentifier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The identifier of the HSM client certificate.
     */
    @JvmName("utswdgjtyuirwqsw")
    public suspend fun hsmClientCertificateIdentifier(`value`: Output<String>) {
        this.hsmClientCertificateIdentifier = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dlqyferecprjibkt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The identifier of the HSM client certificate.
     */
    @JvmName("gqqndaribbbcbfny")
    public suspend fun hsmClientCertificateIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hsmClientCertificateIdentifier = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cmnhbaurvqusrsru")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cyxeubhjfsvkipge")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): HsmClientCertificateArgs = HsmClientCertificateArgs(
        hsmClientCertificateIdentifier = hsmClientCertificateIdentifier,
        tags = tags,
    )
}
