@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.HsmConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and use database encryption keys in a Hardware Security Module (HSM).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.HsmConfiguration;
 * import com.pulumi.aws.redshift.HsmConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HsmConfiguration("example", HsmConfigurationArgs.builder()
 *             .description("example")
 *             .hsmConfigurationIdentifier("example")
 *             .hsmIpAddress("10.0.0.1")
 *             .hsmPartitionName("aws")
 *             .hsmPartitionPassword("example")
 *             .hsmServerPublicCertificate("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift HSM Client Certificates using `hsm_configuration_identifier`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/hsmConfiguration:HsmConfiguration example example
 * ```
 * @property description A text description of the HSM configuration to be created.
 * @property hsmConfigurationIdentifier The identifier to be assigned to the new Amazon Redshift HSM configuration.
 * @property hsmIpAddress The IP address that the Amazon Redshift cluster must use to access the HSM.
 * @property hsmPartitionName The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.
 * @property hsmPartitionPassword The password required to access the HSM partition.
 * @property hsmServerPublicCertificate The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class HsmConfigurationArgs(
    public val description: Output<String>? = null,
    public val hsmConfigurationIdentifier: Output<String>? = null,
    public val hsmIpAddress: Output<String>? = null,
    public val hsmPartitionName: Output<String>? = null,
    public val hsmPartitionPassword: Output<String>? = null,
    public val hsmServerPublicCertificate: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.HsmConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.redshift.HsmConfigurationArgs =
        com.pulumi.aws.redshift.HsmConfigurationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .hsmConfigurationIdentifier(hsmConfigurationIdentifier?.applyValue({ args0 -> args0 }))
            .hsmIpAddress(hsmIpAddress?.applyValue({ args0 -> args0 }))
            .hsmPartitionName(hsmPartitionName?.applyValue({ args0 -> args0 }))
            .hsmPartitionPassword(hsmPartitionPassword?.applyValue({ args0 -> args0 }))
            .hsmServerPublicCertificate(hsmServerPublicCertificate?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [HsmConfigurationArgs].
 */
@PulumiTagMarker
public class HsmConfigurationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var hsmConfigurationIdentifier: Output<String>? = null

    private var hsmIpAddress: Output<String>? = null

    private var hsmPartitionName: Output<String>? = null

    private var hsmPartitionPassword: Output<String>? = null

    private var hsmServerPublicCertificate: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A text description of the HSM configuration to be created.
     */
    @JvmName("qwnidjfafnmwatol")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The identifier to be assigned to the new Amazon Redshift HSM configuration.
     */
    @JvmName("dhbomjkctvidhspc")
    public suspend fun hsmConfigurationIdentifier(`value`: Output<String>) {
        this.hsmConfigurationIdentifier = value
    }

    /**
     * @param value The IP address that the Amazon Redshift cluster must use to access the HSM.
     */
    @JvmName("qnfvpuhtkewbsecn")
    public suspend fun hsmIpAddress(`value`: Output<String>) {
        this.hsmIpAddress = value
    }

    /**
     * @param value The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.
     */
    @JvmName("dfajkmivimsshikx")
    public suspend fun hsmPartitionName(`value`: Output<String>) {
        this.hsmPartitionName = value
    }

    /**
     * @param value The password required to access the HSM partition.
     */
    @JvmName("paljinixhphodron")
    public suspend fun hsmPartitionPassword(`value`: Output<String>) {
        this.hsmPartitionPassword = value
    }

    /**
     * @param value The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.
     */
    @JvmName("kfroxsaubwjqlxqg")
    public suspend fun hsmServerPublicCertificate(`value`: Output<String>) {
        this.hsmServerPublicCertificate = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pyiypwcsemhjlgqd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A text description of the HSM configuration to be created.
     */
    @JvmName("jvssiowkwmbfymyy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The identifier to be assigned to the new Amazon Redshift HSM configuration.
     */
    @JvmName("dyjtfuoiabyrusix")
    public suspend fun hsmConfigurationIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hsmConfigurationIdentifier = mapped
    }

    /**
     * @param value The IP address that the Amazon Redshift cluster must use to access the HSM.
     */
    @JvmName("eyliveqhmokssruv")
    public suspend fun hsmIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hsmIpAddress = mapped
    }

    /**
     * @param value The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.
     */
    @JvmName("yyhrmmobiulobxws")
    public suspend fun hsmPartitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hsmPartitionName = mapped
    }

    /**
     * @param value The password required to access the HSM partition.
     */
    @JvmName("jfkmclrdqritumua")
    public suspend fun hsmPartitionPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hsmPartitionPassword = mapped
    }

    /**
     * @param value The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.
     */
    @JvmName("eilpenpbrwxfbjwy")
    public suspend fun hsmServerPublicCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hsmServerPublicCertificate = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dhpxdclogdtaripx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iykmxpsfcqopelmc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): HsmConfigurationArgs = HsmConfigurationArgs(
        description = description,
        hsmConfigurationIdentifier = hsmConfigurationIdentifier,
        hsmIpAddress = hsmIpAddress,
        hsmPartitionName = hsmPartitionName,
        hsmPartitionPassword = hsmPartitionPassword,
        hsmServerPublicCertificate = hsmServerPublicCertificate,
        tags = tags,
    )
}
