@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Partner].
 */
@PulumiTagMarker
public class PartnerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PartnerArgs = PartnerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PartnerArgsBuilder.() -> Unit) {
        val builder = PartnerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Partner {
        val builtJavaResource = com.pulumi.aws.redshift.Partner(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Partner(builtJavaResource)
    }
}

/**
 * Creates a new Amazon Redshift Partner Integration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Partner;
 * import com.pulumi.aws.redshift.PartnerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Partner("example", PartnerArgs.builder()
 *             .clusterIdentifier(aws_redshift_cluster.example().id())
 *             .accountId(1234567910)
 *             .databaseName(aws_redshift_cluster.example().database_name())
 *             .partnerName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift usage limits using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/partner:Partner example 01234567910:cluster-example-id:example:example
 * ```
 *
 */
public class Partner internal constructor(
    override val javaResource: com.pulumi.aws.redshift.Partner,
) : KotlinCustomResource(javaResource, PartnerMapper) {
    /**
     * The Amazon Web Services account ID that owns the cluster.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The cluster identifier of the cluster that receives data from the partner.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * The name of the database that receives data from the partner.
     */
    public val databaseName: Output<String>
        get() = javaResource.databaseName().applyValue({ args0 -> args0 })

    /**
     * The name of the partner that is authorized to send data.
     */
    public val partnerName: Output<String>
        get() = javaResource.partnerName().applyValue({ args0 -> args0 })

    /**
     * (Optional) The partner integration status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * (Optional) The status message provided by the partner.
     */
    public val statusMessage: Output<String>
        get() = javaResource.statusMessage().applyValue({ args0 -> args0 })
}

public object PartnerMapper : ResourceMapper<Partner> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.Partner::class == javaResource::class

    override fun map(javaResource: Resource): Partner = Partner(
        javaResource as
            com.pulumi.aws.redshift.Partner,
    )
}

/**
 * @see [Partner].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Partner].
 */
public suspend fun partner(name: String, block: suspend PartnerResourceBuilder.() -> Unit):
    Partner {
    val builder = PartnerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Partner].
 * @param name The _unique_ name of the resulting resource.
 */
public fun partner(name: String): Partner {
    val builder = PartnerResourceBuilder()
    builder.name(name)
    return builder.build()
}
