@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.RedshiftFunctions.getClusterCredentialsPlain
import com.pulumi.aws.redshift.RedshiftFunctions.getClusterPlain
import com.pulumi.aws.redshift.RedshiftFunctions.getOrderableClusterPlain
import com.pulumi.aws.redshift.RedshiftFunctions.getServiceAccountPlain
import com.pulumi.aws.redshift.RedshiftFunctions.getSubnetGroupPlain
import com.pulumi.aws.redshift.kotlin.inputs.GetClusterCredentialsPlainArgs
import com.pulumi.aws.redshift.kotlin.inputs.GetClusterCredentialsPlainArgsBuilder
import com.pulumi.aws.redshift.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.aws.redshift.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.aws.redshift.kotlin.inputs.GetOrderableClusterPlainArgs
import com.pulumi.aws.redshift.kotlin.inputs.GetOrderableClusterPlainArgsBuilder
import com.pulumi.aws.redshift.kotlin.inputs.GetServiceAccountPlainArgs
import com.pulumi.aws.redshift.kotlin.inputs.GetServiceAccountPlainArgsBuilder
import com.pulumi.aws.redshift.kotlin.inputs.GetSubnetGroupPlainArgs
import com.pulumi.aws.redshift.kotlin.inputs.GetSubnetGroupPlainArgsBuilder
import com.pulumi.aws.redshift.kotlin.outputs.GetClusterCredentialsResult
import com.pulumi.aws.redshift.kotlin.outputs.GetClusterResult
import com.pulumi.aws.redshift.kotlin.outputs.GetOrderableClusterResult
import com.pulumi.aws.redshift.kotlin.outputs.GetServiceAccountResult
import com.pulumi.aws.redshift.kotlin.outputs.GetSubnetGroupResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.redshift.kotlin.outputs.GetClusterCredentialsResult.Companion.toKotlin as getClusterCredentialsResultToKotlin
import com.pulumi.aws.redshift.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.aws.redshift.kotlin.outputs.GetOrderableClusterResult.Companion.toKotlin as getOrderableClusterResultToKotlin
import com.pulumi.aws.redshift.kotlin.outputs.GetServiceAccountResult.Companion.toKotlin as getServiceAccountResultToKotlin
import com.pulumi.aws.redshift.kotlin.outputs.GetSubnetGroupResult.Companion.toKotlin as getSubnetGroupResultToKotlin

public object RedshiftFunctions {
    /**
     * Provides details about a specific redshift cluster.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetClusterArgs;
     * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
     * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
     * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs;
     * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getCluster(GetClusterArgs.builder()
     *             .clusterIdentifier("example-cluster")
     *             .build());
     *         var exampleStream = new FirehoseDeliveryStream("exampleStream", FirehoseDeliveryStreamArgs.builder()
     *             .destination("redshift")
     *             .redshiftConfiguration(FirehoseDeliveryStreamRedshiftConfigurationArgs.builder()
     *                 .roleArn(aws_iam_role.firehose_role().arn())
     *                 .clusterJdbcurl(String.format("jdbc:redshift://%s/%s", example.applyValue(getClusterResult -> getClusterResult.endpoint()),example.applyValue(getClusterResult -> getClusterResult.databaseName())))
     *                 .username("exampleuser")
     *                 .password("Exampl3Pass")
     *                 .dataTableName("example-table")
     *                 .copyOptions("delimiter '|'")
     *                 .dataTableColumns("example-col")
     *                 .s3Configuration(FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs.builder()
     *                     .roleArn(aws_iam_role.firehose_role().arn())
     *                     .bucketArn(aws_s3_bucket.bucket().arn())
     *                     .bufferSize(10)
     *                     .bufferInterval(400)
     *                     .compressionFormat("GZIP")
     *                     .build())
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCluster.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterIdentifier Cluster identifier
     * @param tags Tags associated to the cluster
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(clusterIdentifier: String, tags: Map<String, String>? = null):
        GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterIdentifier = clusterIdentifier,
            tags = tags,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshift&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit):
        GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides redshift cluster temporary credentials.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetClusterCredentialsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getClusterCredentials(GetClusterCredentialsArgs.builder()
     *             .clusterIdentifier(aws_redshift_cluster.example().cluster_identifier())
     *             .dbUser(aws_redshift_cluster.example().master_username())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getClusterCredentials.
     * @return A collection of values returned by getClusterCredentials.
     */
    public suspend fun getClusterCredentials(argument: GetClusterCredentialsPlainArgs):
        GetClusterCredentialsResult =
        getClusterCredentialsResultToKotlin(getClusterCredentialsPlain(argument.toJava()).await())

    /**
     * @see [getClusterCredentials].
     * @param autoCreate Create a database user with the name specified for the user named in `db_user` if one does not exist.
     * @param clusterIdentifier Unique identifier of the cluster that contains the database for which your are requesting credentials.
     * @param dbGroups List of the names of existing database groups that the user named in `db_user` will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to `PUBLIC`.
     * @param dbName Name of a database that DbUser is authorized to log on to. If `db_name` is not specified, `db_user` can log on to any existing database.
     * @param dbUser Name of a database user. If a user name matching `db_user` exists in the database, the temporary user credentials have the same permissions as the  existing user. If `db_user` doesn't exist in the database and `auto_create` is `True`, a new user is created using the value for `db_user` with `PUBLIC` permissions.  If a database user matching the value for `db_user` doesn't exist and `not` is `False`, then the command succeeds but the connection attempt will fail because the user doesn't exist in the database.
     * @param durationSeconds The number of seconds until the returned temporary password expires. Valid values are between `900` and `3600`. Default value is `900`.
     * @return A collection of values returned by getClusterCredentials.
     */
    public suspend fun getClusterCredentials(
        autoCreate: Boolean? = null,
        clusterIdentifier: String,
        dbGroups: List<String>? = null,
        dbName: String? = null,
        dbUser: String,
        durationSeconds: Int? = null,
    ): GetClusterCredentialsResult {
        val argument = GetClusterCredentialsPlainArgs(
            autoCreate = autoCreate,
            clusterIdentifier = clusterIdentifier,
            dbGroups = dbGroups,
            dbName = dbName,
            dbUser = dbUser,
            durationSeconds = durationSeconds,
        )
        return getClusterCredentialsResultToKotlin(getClusterCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshift&#46;kotlin&#46;inputs&#46;GetClusterCredentialsPlainArgs].
     * @return A collection of values returned by getClusterCredentials.
     */
    public suspend
    fun getClusterCredentials(argument: suspend GetClusterCredentialsPlainArgsBuilder.() -> Unit):
        GetClusterCredentialsResult {
        val builder = GetClusterCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterCredentialsResultToKotlin(getClusterCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about Redshift Orderable Clusters and valid parameter combinations.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetOrderableClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = RedshiftFunctions.getOrderableCluster(GetOrderableClusterArgs.builder()
     *             .clusterType("multi-node")
     *             .preferredNodeTypes(
     *                 "dc2.large",
     *                 "ds2.xlarge")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOrderableCluster.
     * @return A collection of values returned by getOrderableCluster.
     */
    public suspend fun getOrderableCluster(argument: GetOrderableClusterPlainArgs):
        GetOrderableClusterResult =
        getOrderableClusterResultToKotlin(getOrderableClusterPlain(argument.toJava()).await())

    /**
     * @see [getOrderableCluster].
     * @param clusterType Reshift Cluster typeE.g., `multi-node` or `single-node`
     * @param clusterVersion Redshift Cluster versionE.g., `1.0`
     * @param nodeType Redshift Cluster node typeE.g., `dc2.8xlarge`
     * @param preferredNodeTypes Ordered list of preferred Redshift Cluster node types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     * @return A collection of values returned by getOrderableCluster.
     */
    public suspend fun getOrderableCluster(
        clusterType: String? = null,
        clusterVersion: String? = null,
        nodeType: String? = null,
        preferredNodeTypes: List<String>? = null,
    ): GetOrderableClusterResult {
        val argument = GetOrderableClusterPlainArgs(
            clusterType = clusterType,
            clusterVersion = clusterVersion,
            nodeType = nodeType,
            preferredNodeTypes = preferredNodeTypes,
        )
        return getOrderableClusterResultToKotlin(getOrderableClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getOrderableCluster].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshift&#46;kotlin&#46;inputs&#46;GetOrderableClusterPlainArgs].
     * @return A collection of values returned by getOrderableCluster.
     */
    public suspend
    fun getOrderableCluster(argument: suspend GetOrderableClusterPlainArgsBuilder.() -> Unit):
        GetOrderableClusterResult {
        val builder = GetOrderableClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrderableClusterResultToKotlin(getOrderableClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the Account ID of the [AWS Redshift Service Account](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
     * in a given region for the purpose of allowing Redshift to store audit data in S3.
     * > **Note:** AWS documentation [states that](https://docs&#46;aws&#46;amazon&#46;com/redshift/latest/mgmt/db-auditing&#46;html#db-auditing-bucket-permissions) a [service principal name](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services) should be used instead of an AWS account ID in any relevant IAM policy.
     * The `aws.redshift.getServiceAccount` data source has been deprecated and will be removed in a future version.
     * @param argument A collection of arguments for invoking getServiceAccount.
     * @return A collection of values returned by getServiceAccount.
     */
    public suspend fun getServiceAccount(argument: GetServiceAccountPlainArgs):
        GetServiceAccountResult =
        getServiceAccountResultToKotlin(getServiceAccountPlain(argument.toJava()).await())

    /**
     * @see [getServiceAccount].
     * @param region Name of the region whose AWS Redshift account ID is desired.
     * Defaults to the region from the AWS provider configuration.
     * @return A collection of values returned by getServiceAccount.
     */
    public suspend fun getServiceAccount(region: String? = null): GetServiceAccountResult {
        val argument = GetServiceAccountPlainArgs(
            region = region,
        )
        return getServiceAccountResultToKotlin(getServiceAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceAccount].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshift&#46;kotlin&#46;inputs&#46;GetServiceAccountPlainArgs].
     * @return A collection of values returned by getServiceAccount.
     */
    public suspend
    fun getServiceAccount(argument: suspend GetServiceAccountPlainArgsBuilder.() -> Unit):
        GetServiceAccountResult {
        val builder = GetServiceAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceAccountResultToKotlin(getServiceAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific redshift subnet group.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetSubnetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getSubnetGroup(GetSubnetGroupArgs.builder()
     *             .name(aws_redshift_subnet_group.example().name())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSubnetGroup.
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(argument: GetSubnetGroupPlainArgs): GetSubnetGroupResult =
        getSubnetGroupResultToKotlin(getSubnetGroupPlain(argument.toJava()).await())

    /**
     * @see [getSubnetGroup].
     * @param name Name of the cluster subnet group for which information is requested.
     * @param tags Tags associated to the Subnet Group
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(name: String, tags: Map<String, String>? = null):
        GetSubnetGroupResult {
        val argument = GetSubnetGroupPlainArgs(
            name = name,
            tags = tags,
        )
        return getSubnetGroupResultToKotlin(getSubnetGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubnetGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;redshift&#46;kotlin&#46;inputs&#46;GetSubnetGroupPlainArgs].
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(argument: suspend GetSubnetGroupPlainArgsBuilder.() -> Unit):
        GetSubnetGroupResult {
        val builder = GetSubnetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubnetGroupResultToKotlin(getSubnetGroupPlain(builtArgument.toJava()).await())
    }
}
