@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.ResourcePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Resource Policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.ResourcePolicy;
 * import com.pulumi.aws.redshift.ResourcePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourcePolicy("example", ResourcePolicyArgs.builder()
 *             .resourceArn(aws_redshift_cluster.example().cluster_namespace_arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", "arn:aws:iam::12345678901:root")
 *                         )),
 *                         jsonProperty("Action", "redshift:CreateInboundIntegration"),
 *                         jsonProperty("Resource", aws_redshift_cluster.example().cluster_namespace_arn()),
 *                         jsonProperty("Sid", "")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Resource Policies using the `resource_arn`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/resourcePolicy:ResourcePolicy example example
 * ```
 * @property policy The content of the resource policy being updated.
 * @property resourceArn The Amazon Resource Name (ARN) of the account to create or update a resource policy for.
 */
public data class ResourcePolicyArgs(
    public val policy: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.ResourcePolicyArgs> {
    override fun toJava(): com.pulumi.aws.redshift.ResourcePolicyArgs =
        com.pulumi.aws.redshift.ResourcePolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourcePolicyArgs].
 */
@PulumiTagMarker
public class ResourcePolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value The content of the resource policy being updated.
     */
    @JvmName("jumdedtpjonfehdp")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the account to create or update a resource policy for.
     */
    @JvmName("aeshjscebljxgwdl")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The content of the resource policy being updated.
     */
    @JvmName("xbwkkwmwhnbxdnew")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the account to create or update a resource policy for.
     */
    @JvmName("pwlpnxyluxeychce")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): ResourcePolicyArgs = ResourcePolicyArgs(
        policy = policy,
        resourceArn = resourceArn,
    )
}
