@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.kotlin.outputs.ScheduledActionTargetAction
import com.pulumi.aws.redshift.kotlin.outputs.ScheduledActionTargetAction.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ScheduledAction].
 */
@PulumiTagMarker
public class ScheduledActionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduledActionArgs = ScheduledActionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduledActionArgsBuilder.() -> Unit) {
        val builder = ScheduledActionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ScheduledAction {
        val builtJavaResource = com.pulumi.aws.redshift.ScheduledAction(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ScheduledAction(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ### Pause Cluster Action
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.redshift.ScheduledAction;
 * import com.pulumi.aws.redshift.ScheduledActionArgs;
 * import com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionArgs;
 * import com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionPauseClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("scheduler.redshift.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "redshift:PauseCluster",
 *                     "redshift:ResumeCluster",
 *                     "redshift:ResizeCluster")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var examplePolicy = new Policy("examplePolicy", PolicyArgs.builder()
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .policyArn(examplePolicy.arn())
 *             .role(exampleRole.name())
 *             .build());
 *         var exampleScheduledAction = new ScheduledAction("exampleScheduledAction", ScheduledActionArgs.builder()
 *             .schedule("cron(00 23 * * ? *)")
 *             .iamRole(exampleRole.arn())
 *             .targetAction(ScheduledActionTargetActionArgs.builder()
 *                 .pauseCluster(ScheduledActionTargetActionPauseClusterArgs.builder()
 *                     .clusterIdentifier("tf-redshift001")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Resize Cluster Action
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.ScheduledAction;
 * import com.pulumi.aws.redshift.ScheduledActionArgs;
 * import com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionArgs;
 * import com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionResizeClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ScheduledAction("example", ScheduledActionArgs.builder()
 *             .schedule("cron(00 23 * * ? *)")
 *             .iamRole(aws_iam_role.example().arn())
 *             .targetAction(ScheduledActionTargetActionArgs.builder()
 *                 .resizeCluster(ScheduledActionTargetActionResizeClusterArgs.builder()
 *                     .clusterIdentifier("tf-redshift001")
 *                     .clusterType("multi-node")
 *                     .nodeType("dc1.large")
 *                     .numberOfNodes(2)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Scheduled Action using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/scheduledAction:ScheduledAction example tf-redshift-scheduled-action
 * ```
 *
 */
public class ScheduledAction internal constructor(
    override val javaResource: com.pulumi.aws.redshift.ScheduledAction,
) : KotlinCustomResource(javaResource, ScheduledActionMapper) {
    /**
     * The description of the scheduled action.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable the scheduled action. Default is `true` .
     */
    public val enable: Output<Boolean>?
        get() = javaResource.enable().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The end time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
     */
    public val endTime: Output<String>?
        get() = javaResource.endTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The IAM role to assume to run the scheduled action.
     */
    public val iamRole: Output<String>
        get() = javaResource.iamRole().applyValue({ args0 -> args0 })

    /**
     * The scheduled action name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The schedule of action. The schedule is defined format of "at expression" or "cron expression", for example `at(2016-03-04T17:27:00)` or `cron(0 10 ? * MON *)`. See [Scheduled Action](https://docs.aws.amazon.com/redshift/latest/APIReference/API_ScheduledAction.html) for more information.
     */
    public val schedule: Output<String>
        get() = javaResource.schedule().applyValue({ args0 -> args0 })

    /**
     * The start time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
     */
    public val startTime: Output<String>?
        get() = javaResource.startTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Target action. Documented below.
     */
    public val targetAction: Output<ScheduledActionTargetAction>
        get() = javaResource.targetAction().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
}

public object ScheduledActionMapper : ResourceMapper<ScheduledAction> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.ScheduledAction::class == javaResource::class

    override fun map(javaResource: Resource): ScheduledAction = ScheduledAction(
        javaResource as
            com.pulumi.aws.redshift.ScheduledAction,
    )
}

/**
 * @see [ScheduledAction].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScheduledAction].
 */
public suspend fun scheduledAction(
    name: String,
    block: suspend ScheduledActionResourceBuilder.() -> Unit,
): ScheduledAction {
    val builder = ScheduledActionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScheduledAction].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scheduledAction(name: String): ScheduledAction {
    val builder = ScheduledActionResourceBuilder()
    builder.name(name)
    return builder.build()
}
