@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.ScheduledActionArgs.builder
import com.pulumi.aws.redshift.kotlin.inputs.ScheduledActionTargetActionArgs
import com.pulumi.aws.redshift.kotlin.inputs.ScheduledActionTargetActionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ### Pause Cluster Action
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.redshift.ScheduledAction;
 * import com.pulumi.aws.redshift.ScheduledActionArgs;
 * import com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionArgs;
 * import com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionPauseClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("scheduler.redshift.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "redshift:PauseCluster",
 *                     "redshift:ResumeCluster",
 *                     "redshift:ResizeCluster")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var examplePolicy = new Policy("examplePolicy", PolicyArgs.builder()
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .policyArn(examplePolicy.arn())
 *             .role(exampleRole.name())
 *             .build());
 *         var exampleScheduledAction = new ScheduledAction("exampleScheduledAction", ScheduledActionArgs.builder()
 *             .schedule("cron(00 23 * * ? *)")
 *             .iamRole(exampleRole.arn())
 *             .targetAction(ScheduledActionTargetActionArgs.builder()
 *                 .pauseCluster(ScheduledActionTargetActionPauseClusterArgs.builder()
 *                     .clusterIdentifier("tf-redshift001")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Resize Cluster Action
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.ScheduledAction;
 * import com.pulumi.aws.redshift.ScheduledActionArgs;
 * import com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionArgs;
 * import com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionResizeClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ScheduledAction("example", ScheduledActionArgs.builder()
 *             .schedule("cron(00 23 * * ? *)")
 *             .iamRole(aws_iam_role.example().arn())
 *             .targetAction(ScheduledActionTargetActionArgs.builder()
 *                 .resizeCluster(ScheduledActionTargetActionResizeClusterArgs.builder()
 *                     .clusterIdentifier("tf-redshift001")
 *                     .clusterType("multi-node")
 *                     .nodeType("dc1.large")
 *                     .numberOfNodes(2)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Scheduled Action using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/scheduledAction:ScheduledAction example tf-redshift-scheduled-action
 * ```
 * @property description The description of the scheduled action.
 * @property enable Whether to enable the scheduled action. Default is `true` .
 * @property endTime The end time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
 * @property iamRole The IAM role to assume to run the scheduled action.
 * @property name The scheduled action name.
 * @property schedule The schedule of action. The schedule is defined format of "at expression" or "cron expression", for example `at(2016-03-04T17:27:00)` or `cron(0 10 ? * MON *)`. See [Scheduled Action](https://docs.aws.amazon.com/redshift/latest/APIReference/API_ScheduledAction.html) for more information.
 * @property startTime The start time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
 * @property targetAction Target action. Documented below.
 */
public data class ScheduledActionArgs(
    public val description: Output<String>? = null,
    public val enable: Output<Boolean>? = null,
    public val endTime: Output<String>? = null,
    public val iamRole: Output<String>? = null,
    public val name: Output<String>? = null,
    public val schedule: Output<String>? = null,
    public val startTime: Output<String>? = null,
    public val targetAction: Output<ScheduledActionTargetActionArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.ScheduledActionArgs> {
    override fun toJava(): com.pulumi.aws.redshift.ScheduledActionArgs =
        com.pulumi.aws.redshift.ScheduledActionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .iamRole(iamRole?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .targetAction(targetAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ScheduledActionArgs].
 */
@PulumiTagMarker
public class ScheduledActionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var enable: Output<Boolean>? = null

    private var endTime: Output<String>? = null

    private var iamRole: Output<String>? = null

    private var name: Output<String>? = null

    private var schedule: Output<String>? = null

    private var startTime: Output<String>? = null

    private var targetAction: Output<ScheduledActionTargetActionArgs>? = null

    /**
     * @param value The description of the scheduled action.
     */
    @JvmName("slsvgwqvydybyxma")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether to enable the scheduled action. Default is `true` .
     */
    @JvmName("hcxwsjgonmombbgw")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value The end time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
     */
    @JvmName("wacgkxftqrqbxjxx")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value The IAM role to assume to run the scheduled action.
     */
    @JvmName("ssyfxmrgqucesfmc")
    public suspend fun iamRole(`value`: Output<String>) {
        this.iamRole = value
    }

    /**
     * @param value The scheduled action name.
     */
    @JvmName("fxxfqolblotreqvg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The schedule of action. The schedule is defined format of "at expression" or "cron expression", for example `at(2016-03-04T17:27:00)` or `cron(0 10 ? * MON *)`. See [Scheduled Action](https://docs.aws.amazon.com/redshift/latest/APIReference/API_ScheduledAction.html) for more information.
     */
    @JvmName("cqrlxijqgvsnqrte")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value The start time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
     */
    @JvmName("xohswjethrfccdwa")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Target action. Documented below.
     */
    @JvmName("cifylsjigsfpsywk")
    public suspend fun targetAction(`value`: Output<ScheduledActionTargetActionArgs>) {
        this.targetAction = value
    }

    /**
     * @param value The description of the scheduled action.
     */
    @JvmName("tjnjegttxugfkwkf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether to enable the scheduled action. Default is `true` .
     */
    @JvmName("tupoilikbwiuvrsb")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value The end time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
     */
    @JvmName("bxkqyufdvxnipjvj")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value The IAM role to assume to run the scheduled action.
     */
    @JvmName("mqdxuvjfvgfdahfa")
    public suspend fun iamRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRole = mapped
    }

    /**
     * @param value The scheduled action name.
     */
    @JvmName("natvsujaqhxdvbyh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The schedule of action. The schedule is defined format of "at expression" or "cron expression", for example `at(2016-03-04T17:27:00)` or `cron(0 10 ? * MON *)`. See [Scheduled Action](https://docs.aws.amazon.com/redshift/latest/APIReference/API_ScheduledAction.html) for more information.
     */
    @JvmName("ytidwuhnweeldopi")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value The start time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
     */
    @JvmName("ydboqbykumdldojr")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Target action. Documented below.
     */
    @JvmName("aprwynhhthbmvajp")
    public suspend fun targetAction(`value`: ScheduledActionTargetActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAction = mapped
    }

    /**
     * @param argument Target action. Documented below.
     */
    @JvmName("hvbmxtbgntqobdyi")
    public suspend
    fun targetAction(argument: suspend ScheduledActionTargetActionArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduledActionTargetActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetAction = mapped
    }

    internal fun build(): ScheduledActionArgs = ScheduledActionArgs(
        description = description,
        enable = enable,
        endTime = endTime,
        iamRole = iamRole,
        name = name,
        schedule = schedule,
        startTime = startTime,
        targetAction = targetAction,
    )
}
