@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.SnapshotScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.SnapshotSchedule;
 * import com.pulumi.aws.redshift.SnapshotScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SnapshotSchedule("default", SnapshotScheduleArgs.builder()
 *             .definitions("rate(12 hours)")
 *             .identifier("tf-redshift-snapshot-schedule")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Snapshot Schedule using the `identifier`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/snapshotSchedule:SnapshotSchedule default tf-redshift-snapshot-schedule
 * ```
 * @property definitions The definition of the snapshot schedule. The definition is made up of schedule expressions, for example `cron(30 12 *)` or `rate(12 hours)`.
 * @property description The description of the snapshot schedule.
 * @property forceDestroy Whether to destroy all associated clusters with this snapshot schedule on deletion. Must be enabled and applied before attempting deletion.
 * @property identifier The snapshot schedule identifier. If omitted, this provider will assign a random, unique identifier.
 * @property identifierPrefix Creates a unique
 * identifier beginning with the specified prefix. Conflicts with `identifier`.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SnapshotScheduleArgs(
    public val definitions: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val identifier: Output<String>? = null,
    public val identifierPrefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.SnapshotScheduleArgs> {
    override fun toJava(): com.pulumi.aws.redshift.SnapshotScheduleArgs =
        com.pulumi.aws.redshift.SnapshotScheduleArgs.builder()
            .definitions(definitions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .identifier(identifier?.applyValue({ args0 -> args0 }))
            .identifierPrefix(identifierPrefix?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SnapshotScheduleArgs].
 */
@PulumiTagMarker
public class SnapshotScheduleArgsBuilder internal constructor() {
    private var definitions: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var identifier: Output<String>? = null

    private var identifierPrefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The definition of the snapshot schedule. The definition is made up of schedule expressions, for example `cron(30 12 *)` or `rate(12 hours)`.
     */
    @JvmName("eaasgmyowamvrjbn")
    public suspend fun definitions(`value`: Output<List<String>>) {
        this.definitions = value
    }

    @JvmName("gxagmehgmmhtcaew")
    public suspend fun definitions(vararg values: Output<String>) {
        this.definitions = Output.all(values.asList())
    }

    /**
     * @param values The definition of the snapshot schedule. The definition is made up of schedule expressions, for example `cron(30 12 *)` or `rate(12 hours)`.
     */
    @JvmName("hcxujkcexoutckop")
    public suspend fun definitions(values: List<Output<String>>) {
        this.definitions = Output.all(values)
    }

    /**
     * @param value The description of the snapshot schedule.
     */
    @JvmName("bsgtlwngymbfvjaj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether to destroy all associated clusters with this snapshot schedule on deletion. Must be enabled and applied before attempting deletion.
     */
    @JvmName("feknaoaafqcstgif")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value The snapshot schedule identifier. If omitted, this provider will assign a random, unique identifier.
     */
    @JvmName("eaoefnrpxqgtclgr")
    public suspend fun identifier(`value`: Output<String>) {
        this.identifier = value
    }

    /**
     * @param value Creates a unique
     * identifier beginning with the specified prefix. Conflicts with `identifier`.
     */
    @JvmName("dbgavaiwgugfvvhp")
    public suspend fun identifierPrefix(`value`: Output<String>) {
        this.identifierPrefix = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jnnaidvawsqwxyix")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The definition of the snapshot schedule. The definition is made up of schedule expressions, for example `cron(30 12 *)` or `rate(12 hours)`.
     */
    @JvmName("bisoqwafrmpohccr")
    public suspend fun definitions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definitions = mapped
    }

    /**
     * @param values The definition of the snapshot schedule. The definition is made up of schedule expressions, for example `cron(30 12 *)` or `rate(12 hours)`.
     */
    @JvmName("meqtfyigkfrgmrqq")
    public suspend fun definitions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.definitions = mapped
    }

    /**
     * @param value The description of the snapshot schedule.
     */
    @JvmName("sahiueltldhwsvsi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether to destroy all associated clusters with this snapshot schedule on deletion. Must be enabled and applied before attempting deletion.
     */
    @JvmName("hmrjvhxrxrxttnim")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value The snapshot schedule identifier. If omitted, this provider will assign a random, unique identifier.
     */
    @JvmName("thhpuqwwnsptpdqm")
    public suspend fun identifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param value Creates a unique
     * identifier beginning with the specified prefix. Conflicts with `identifier`.
     */
    @JvmName("rurrrffpguagilex")
    public suspend fun identifierPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifierPrefix = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rgqxhhrmvflsctul")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("smgnequvqjedyobn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SnapshotScheduleArgs = SnapshotScheduleArgs(
        definitions = definitions,
        description = description,
        forceDestroy = forceDestroy,
        identifier = identifier,
        identifierPrefix = identifierPrefix,
        tags = tags,
    )
}
