@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SnapshotScheduleAssociation].
 */
@PulumiTagMarker
public class SnapshotScheduleAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotScheduleAssociationArgs = SnapshotScheduleAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotScheduleAssociationArgsBuilder.() -> Unit) {
        val builder = SnapshotScheduleAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SnapshotScheduleAssociation {
        val builtJavaResource =
            com.pulumi.aws.redshift.SnapshotScheduleAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SnapshotScheduleAssociation(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Cluster;
 * import com.pulumi.aws.redshift.ClusterArgs;
 * import com.pulumi.aws.redshift.SnapshotSchedule;
 * import com.pulumi.aws.redshift.SnapshotScheduleArgs;
 * import com.pulumi.aws.redshift.SnapshotScheduleAssociation;
 * import com.pulumi.aws.redshift.SnapshotScheduleAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .clusterIdentifier("tf-redshift-cluster")
 *             .databaseName("mydb")
 *             .masterUsername("foo")
 *             .masterPassword("Mustbe8characters")
 *             .nodeType("dc1.large")
 *             .clusterType("single-node")
 *             .build());
 *         var defaultSnapshotSchedule = new SnapshotSchedule("defaultSnapshotSchedule", SnapshotScheduleArgs.builder()
 *             .identifier("tf-redshift-snapshot-schedule")
 *             .definitions("rate(12 hours)")
 *             .build());
 *         var defaultSnapshotScheduleAssociation = new SnapshotScheduleAssociation("defaultSnapshotScheduleAssociation", SnapshotScheduleAssociationArgs.builder()
 *             .clusterIdentifier(defaultCluster.id())
 *             .scheduleIdentifier(defaultSnapshotSchedule.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Snapshot Schedule Association using the `<cluster-identifier>/<schedule-identifier>`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/snapshotScheduleAssociation:SnapshotScheduleAssociation default tf-redshift-cluster/tf-redshift-snapshot-schedule
 * ```
 *
 */
public class SnapshotScheduleAssociation internal constructor(
    override val javaResource: com.pulumi.aws.redshift.SnapshotScheduleAssociation,
) : KotlinCustomResource(javaResource, SnapshotScheduleAssociationMapper) {
    /**
     * The cluster identifier.
     */
    public val clusterIdentifier: Output<String>
        get() = javaResource.clusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * The snapshot schedule identifier.
     */
    public val scheduleIdentifier: Output<String>
        get() = javaResource.scheduleIdentifier().applyValue({ args0 -> args0 })
}

public object SnapshotScheduleAssociationMapper : ResourceMapper<SnapshotScheduleAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshift.SnapshotScheduleAssociation::class == javaResource::class

    override fun map(javaResource: Resource): SnapshotScheduleAssociation =
        SnapshotScheduleAssociation(
            javaResource as
                com.pulumi.aws.redshift.SnapshotScheduleAssociation,
        )
}

/**
 * @see [SnapshotScheduleAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SnapshotScheduleAssociation].
 */
public suspend fun snapshotScheduleAssociation(
    name: String,
    block: suspend SnapshotScheduleAssociationResourceBuilder.() -> Unit,
):
    SnapshotScheduleAssociation {
    val builder = SnapshotScheduleAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SnapshotScheduleAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshotScheduleAssociation(name: String): SnapshotScheduleAssociation {
    val builder = SnapshotScheduleAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
