@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.SnapshotScheduleAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Cluster;
 * import com.pulumi.aws.redshift.ClusterArgs;
 * import com.pulumi.aws.redshift.SnapshotSchedule;
 * import com.pulumi.aws.redshift.SnapshotScheduleArgs;
 * import com.pulumi.aws.redshift.SnapshotScheduleAssociation;
 * import com.pulumi.aws.redshift.SnapshotScheduleAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .clusterIdentifier("tf-redshift-cluster")
 *             .databaseName("mydb")
 *             .masterUsername("foo")
 *             .masterPassword("Mustbe8characters")
 *             .nodeType("dc1.large")
 *             .clusterType("single-node")
 *             .build());
 *         var defaultSnapshotSchedule = new SnapshotSchedule("defaultSnapshotSchedule", SnapshotScheduleArgs.builder()
 *             .identifier("tf-redshift-snapshot-schedule")
 *             .definitions("rate(12 hours)")
 *             .build());
 *         var defaultSnapshotScheduleAssociation = new SnapshotScheduleAssociation("defaultSnapshotScheduleAssociation", SnapshotScheduleAssociationArgs.builder()
 *             .clusterIdentifier(defaultCluster.id())
 *             .scheduleIdentifier(defaultSnapshotSchedule.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Snapshot Schedule Association using the `<cluster-identifier>/<schedule-identifier>`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/snapshotScheduleAssociation:SnapshotScheduleAssociation default tf-redshift-cluster/tf-redshift-snapshot-schedule
 * ```
 * @property clusterIdentifier The cluster identifier.
 * @property scheduleIdentifier The snapshot schedule identifier.
 */
public data class SnapshotScheduleAssociationArgs(
    public val clusterIdentifier: Output<String>? = null,
    public val scheduleIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.SnapshotScheduleAssociationArgs> {
    override fun toJava(): com.pulumi.aws.redshift.SnapshotScheduleAssociationArgs =
        com.pulumi.aws.redshift.SnapshotScheduleAssociationArgs.builder()
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .scheduleIdentifier(scheduleIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotScheduleAssociationArgs].
 */
@PulumiTagMarker
public class SnapshotScheduleAssociationArgsBuilder internal constructor() {
    private var clusterIdentifier: Output<String>? = null

    private var scheduleIdentifier: Output<String>? = null

    /**
     * @param value The cluster identifier.
     */
    @JvmName("bqfpvuildbaqijtw")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The snapshot schedule identifier.
     */
    @JvmName("fuqadtsuibdeomcg")
    public suspend fun scheduleIdentifier(`value`: Output<String>) {
        this.scheduleIdentifier = value
    }

    /**
     * @param value The cluster identifier.
     */
    @JvmName("cnpqitmwfaqtyqaq")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value The snapshot schedule identifier.
     */
    @JvmName("nllostvwxvhiivui")
    public suspend fun scheduleIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleIdentifier = mapped
    }

    internal fun build(): SnapshotScheduleAssociationArgs = SnapshotScheduleAssociationArgs(
        clusterIdentifier = clusterIdentifier,
        scheduleIdentifier = scheduleIdentifier,
    )
}
