@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.SubnetGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.redshift.SubnetGroup;
 * import com.pulumi.aws.redshift.SubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fooVpc = new Vpc("fooVpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var fooSubnet = new Subnet("fooSubnet", SubnetArgs.builder()
 *             .cidrBlock("10.1.1.0/24")
 *             .availabilityZone("us-west-2a")
 *             .vpcId(fooVpc.id())
 *             .tags(Map.of("Name", "tf-dbsubnet-test-1"))
 *             .build());
 *         var bar = new Subnet("bar", SubnetArgs.builder()
 *             .cidrBlock("10.1.2.0/24")
 *             .availabilityZone("us-west-2b")
 *             .vpcId(fooVpc.id())
 *             .tags(Map.of("Name", "tf-dbsubnet-test-2"))
 *             .build());
 *         var fooSubnetGroup = new SubnetGroup("fooSubnetGroup", SubnetGroupArgs.builder()
 *             .subnetIds(
 *                 fooSubnet.id(),
 *                 bar.id())
 *             .tags(Map.of("environment", "Production"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift subnet groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/subnetGroup:SubnetGroup testgroup1 test-cluster-subnet-group
 * ```
 * @property description The description of the Redshift Subnet group. Defaults to "Managed by Pulumi".
 * @property name The name of the Redshift Subnet group.
 * @property subnetIds An array of VPC subnet IDs.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SubnetGroupArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.SubnetGroupArgs> {
    override fun toJava(): com.pulumi.aws.redshift.SubnetGroupArgs =
        com.pulumi.aws.redshift.SubnetGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SubnetGroupArgs].
 */
@PulumiTagMarker
public class SubnetGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the Redshift Subnet group. Defaults to "Managed by Pulumi".
     */
    @JvmName("teqhalyfwymixuqn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the Redshift Subnet group.
     */
    @JvmName("fiwkungfdjwbfnoj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An array of VPC subnet IDs.
     */
    @JvmName("kwubowivuvpjmaem")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("crdwqsdcjetuxxhg")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values An array of VPC subnet IDs.
     */
    @JvmName("pijnwmkibuviyjpn")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ydxtdstfpveyivhq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the Redshift Subnet group. Defaults to "Managed by Pulumi".
     */
    @JvmName("qtldhobmcvvsdpit")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the Redshift Subnet group.
     */
    @JvmName("pgqmkautxbblipba")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An array of VPC subnet IDs.
     */
    @JvmName("asmeluaampbcgpyk")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values An array of VPC subnet IDs.
     */
    @JvmName("llsrhayxxnahbnni")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eqvdlkcpuqvughtq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("llugvdmjwvfalxqw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SubnetGroupArgs = SubnetGroupArgs(
        description = description,
        name = name,
        subnetIds = subnetIds,
        tags = tags,
    )
}
