@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin

import com.pulumi.aws.redshift.UsageLimitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Usage Limit.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.UsageLimit;
 * import com.pulumi.aws.redshift.UsageLimitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UsageLimit("example", UsageLimitArgs.builder()
 *             .clusterIdentifier(aws_redshift_cluster.example().id())
 *             .featureType("concurrency-scaling")
 *             .limitType("time")
 *             .amount(60)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift usage limits using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:redshift/usageLimit:UsageLimit example example-id
 * ```
 * @property amount The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number.
 * @property breachAction The action that Amazon Redshift takes when the limit is reached. The default is `log`. Valid values are `log`, `emit-metric`, and `disable`.
 * @property clusterIdentifier The identifier of the cluster that you want to limit usage.
 * @property featureType The Amazon Redshift feature that you want to limit. Valid values are `spectrum`, `concurrency-scaling`, and `cross-region-datasharing`.
 * @property limitType The type of limit. Depending on the feature type, this can be based on a time duration or data size. If FeatureType is `spectrum`, then LimitType must be `data-scanned`. If FeatureType is `concurrency-scaling`, then LimitType must be `time`. If FeatureType is `cross-region-datasharing`, then LimitType must be `data-scanned`. Valid values are `data-scanned`, and `time`.
 * @property period The time period that the amount applies to. A weekly period begins on Sunday. The default is `monthly`. Valid values are `daily`, `weekly`, and `monthly`.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class UsageLimitArgs(
    public val amount: Output<Int>? = null,
    public val breachAction: Output<String>? = null,
    public val clusterIdentifier: Output<String>? = null,
    public val featureType: Output<String>? = null,
    public val limitType: Output<String>? = null,
    public val period: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.UsageLimitArgs> {
    override fun toJava(): com.pulumi.aws.redshift.UsageLimitArgs =
        com.pulumi.aws.redshift.UsageLimitArgs.builder()
            .amount(amount?.applyValue({ args0 -> args0 }))
            .breachAction(breachAction?.applyValue({ args0 -> args0 }))
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .featureType(featureType?.applyValue({ args0 -> args0 }))
            .limitType(limitType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [UsageLimitArgs].
 */
@PulumiTagMarker
public class UsageLimitArgsBuilder internal constructor() {
    private var amount: Output<Int>? = null

    private var breachAction: Output<String>? = null

    private var clusterIdentifier: Output<String>? = null

    private var featureType: Output<String>? = null

    private var limitType: Output<String>? = null

    private var period: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number.
     */
    @JvmName("eucrbvexxlpyftpj")
    public suspend fun amount(`value`: Output<Int>) {
        this.amount = value
    }

    /**
     * @param value The action that Amazon Redshift takes when the limit is reached. The default is `log`. Valid values are `log`, `emit-metric`, and `disable`.
     */
    @JvmName("olimigyhusfxmlpb")
    public suspend fun breachAction(`value`: Output<String>) {
        this.breachAction = value
    }

    /**
     * @param value The identifier of the cluster that you want to limit usage.
     */
    @JvmName("ieyyqrtrmckwcmru")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The Amazon Redshift feature that you want to limit. Valid values are `spectrum`, `concurrency-scaling`, and `cross-region-datasharing`.
     */
    @JvmName("kvcaftlvvvhlbesn")
    public suspend fun featureType(`value`: Output<String>) {
        this.featureType = value
    }

    /**
     * @param value The type of limit. Depending on the feature type, this can be based on a time duration or data size. If FeatureType is `spectrum`, then LimitType must be `data-scanned`. If FeatureType is `concurrency-scaling`, then LimitType must be `time`. If FeatureType is `cross-region-datasharing`, then LimitType must be `data-scanned`. Valid values are `data-scanned`, and `time`.
     */
    @JvmName("fmrlnjggllghtogu")
    public suspend fun limitType(`value`: Output<String>) {
        this.limitType = value
    }

    /**
     * @param value The time period that the amount applies to. A weekly period begins on Sunday. The default is `monthly`. Valid values are `daily`, `weekly`, and `monthly`.
     */
    @JvmName("odjfgcvxqgwamjya")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hmophgtejsogvicu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number.
     */
    @JvmName("iclrnvcgqmcnsuwv")
    public suspend fun amount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amount = mapped
    }

    /**
     * @param value The action that Amazon Redshift takes when the limit is reached. The default is `log`. Valid values are `log`, `emit-metric`, and `disable`.
     */
    @JvmName("eslkuivsgdjibquu")
    public suspend fun breachAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.breachAction = mapped
    }

    /**
     * @param value The identifier of the cluster that you want to limit usage.
     */
    @JvmName("utxaeuqtulgajoua")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value The Amazon Redshift feature that you want to limit. Valid values are `spectrum`, `concurrency-scaling`, and `cross-region-datasharing`.
     */
    @JvmName("lqgqhprlalqpvene")
    public suspend fun featureType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featureType = mapped
    }

    /**
     * @param value The type of limit. Depending on the feature type, this can be based on a time duration or data size. If FeatureType is `spectrum`, then LimitType must be `data-scanned`. If FeatureType is `concurrency-scaling`, then LimitType must be `time`. If FeatureType is `cross-region-datasharing`, then LimitType must be `data-scanned`. Valid values are `data-scanned`, and `time`.
     */
    @JvmName("vfcsrxhkluldblst")
    public suspend fun limitType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limitType = mapped
    }

    /**
     * @param value The time period that the amount applies to. A weekly period begins on Sunday. The default is `monthly`. Valid values are `daily`, `weekly`, and `monthly`.
     */
    @JvmName("comapisdddkflgqq")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ryqahckuogcegxtw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iafvgwbsnyslovcr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): UsageLimitArgs = UsageLimitArgs(
        amount = amount,
        breachAction = breachAction,
        clusterIdentifier = clusterIdentifier,
        featureType = featureType,
        limitType = limitType,
        period = period,
        tags = tags,
    )
}
