@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.inputs

import com.pulumi.aws.redshift.inputs.ClusterLoggingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName The name of an existing S3 bucket where the log files are to be stored. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions.
 * For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
 * @property enable Enables logging information such as queries and connection attempts, for the specified Amazon Redshift cluster.
 * @property logDestinationType The log destination type. An enum with possible values of `s3` and `cloudwatch`.
 * @property logExports The collection of exported log types. Log types include the connection log, user log and user activity log. Required when `log_destination_type` is `cloudwatch`. Valid log types are `connectionlog`, `userlog`, and `useractivitylog`.
 * @property s3KeyPrefix The prefix applied to the log file names.
 */
public data class ClusterLoggingArgs(
    public val bucketName: Output<String>? = null,
    public val enable: Output<Boolean>,
    public val logDestinationType: Output<String>? = null,
    public val logExports: Output<List<String>>? = null,
    public val s3KeyPrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.inputs.ClusterLoggingArgs> {
    override fun toJava(): com.pulumi.aws.redshift.inputs.ClusterLoggingArgs =
        com.pulumi.aws.redshift.inputs.ClusterLoggingArgs.builder()
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .enable(enable.applyValue({ args0 -> args0 }))
            .logDestinationType(logDestinationType?.applyValue({ args0 -> args0 }))
            .logExports(logExports?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .s3KeyPrefix(s3KeyPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterLoggingArgs].
 */
@PulumiTagMarker
public class ClusterLoggingArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var enable: Output<Boolean>? = null

    private var logDestinationType: Output<String>? = null

    private var logExports: Output<List<String>>? = null

    private var s3KeyPrefix: Output<String>? = null

    /**
     * @param value The name of an existing S3 bucket where the log files are to be stored. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions.
     * For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
     */
    @JvmName("pgfqfxmrmabxinjh")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value Enables logging information such as queries and connection attempts, for the specified Amazon Redshift cluster.
     */
    @JvmName("yyfcbjltspjnxaim")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value The log destination type. An enum with possible values of `s3` and `cloudwatch`.
     */
    @JvmName("knfnccciykbhefbn")
    public suspend fun logDestinationType(`value`: Output<String>) {
        this.logDestinationType = value
    }

    /**
     * @param value The collection of exported log types. Log types include the connection log, user log and user activity log. Required when `log_destination_type` is `cloudwatch`. Valid log types are `connectionlog`, `userlog`, and `useractivitylog`.
     */
    @JvmName("vaupjbkpfajvqfwp")
    public suspend fun logExports(`value`: Output<List<String>>) {
        this.logExports = value
    }

    @JvmName("nopqyqwcsvioocwy")
    public suspend fun logExports(vararg values: Output<String>) {
        this.logExports = Output.all(values.asList())
    }

    /**
     * @param values The collection of exported log types. Log types include the connection log, user log and user activity log. Required when `log_destination_type` is `cloudwatch`. Valid log types are `connectionlog`, `userlog`, and `useractivitylog`.
     */
    @JvmName("jjaqhjbpsxdtofae")
    public suspend fun logExports(values: List<Output<String>>) {
        this.logExports = Output.all(values)
    }

    /**
     * @param value The prefix applied to the log file names.
     */
    @JvmName("cklhubkclstpjgyb")
    public suspend fun s3KeyPrefix(`value`: Output<String>) {
        this.s3KeyPrefix = value
    }

    /**
     * @param value The name of an existing S3 bucket where the log files are to be stored. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions.
     * For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
     */
    @JvmName("pxbqusoxnpoufjjb")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Enables logging information such as queries and connection attempts, for the specified Amazon Redshift cluster.
     */
    @JvmName("yfcaaoivelhwvkty")
    public suspend fun enable(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value The log destination type. An enum with possible values of `s3` and `cloudwatch`.
     */
    @JvmName("ipqxwyvycrrauims")
    public suspend fun logDestinationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logDestinationType = mapped
    }

    /**
     * @param value The collection of exported log types. Log types include the connection log, user log and user activity log. Required when `log_destination_type` is `cloudwatch`. Valid log types are `connectionlog`, `userlog`, and `useractivitylog`.
     */
    @JvmName("ijtboyvsabxvrjjv")
    public suspend fun logExports(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logExports = mapped
    }

    /**
     * @param values The collection of exported log types. Log types include the connection log, user log and user activity log. Required when `log_destination_type` is `cloudwatch`. Valid log types are `connectionlog`, `userlog`, and `useractivitylog`.
     */
    @JvmName("tqtpquiueeqcikwk")
    public suspend fun logExports(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logExports = mapped
    }

    /**
     * @param value The prefix applied to the log file names.
     */
    @JvmName("gxiowsxilngxkmdc")
    public suspend fun s3KeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3KeyPrefix = mapped
    }

    internal fun build(): ClusterLoggingArgs = ClusterLoggingArgs(
        bucketName = bucketName,
        enable = enable ?: throw PulumiNullFieldException("enable"),
        logDestinationType = logDestinationType,
        logExports = logExports,
        s3KeyPrefix = s3KeyPrefix,
    )
}
