@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.inputs

import com.pulumi.aws.redshift.inputs.ClusterSnapshotCopyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destinationRegion The destination region that you want to copy snapshots to.
 * @property grantName The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
 * @property retentionPeriod The number of days to retain automated snapshots in the destination region after they are copied from the source region. Defaults to `7`.
 */
public data class ClusterSnapshotCopyArgs(
    public val destinationRegion: Output<String>,
    public val grantName: Output<String>? = null,
    public val retentionPeriod: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshift.inputs.ClusterSnapshotCopyArgs> {
    override fun toJava(): com.pulumi.aws.redshift.inputs.ClusterSnapshotCopyArgs =
        com.pulumi.aws.redshift.inputs.ClusterSnapshotCopyArgs.builder()
            .destinationRegion(destinationRegion.applyValue({ args0 -> args0 }))
            .grantName(grantName?.applyValue({ args0 -> args0 }))
            .retentionPeriod(retentionPeriod?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterSnapshotCopyArgs].
 */
@PulumiTagMarker
public class ClusterSnapshotCopyArgsBuilder internal constructor() {
    private var destinationRegion: Output<String>? = null

    private var grantName: Output<String>? = null

    private var retentionPeriod: Output<Int>? = null

    /**
     * @param value The destination region that you want to copy snapshots to.
     */
    @JvmName("gjxkqovrvwywldyl")
    public suspend fun destinationRegion(`value`: Output<String>) {
        this.destinationRegion = value
    }

    /**
     * @param value The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
     */
    @JvmName("pfvreeiyryqwxoej")
    public suspend fun grantName(`value`: Output<String>) {
        this.grantName = value
    }

    /**
     * @param value The number of days to retain automated snapshots in the destination region after they are copied from the source region. Defaults to `7`.
     */
    @JvmName("wkasibcsogjjjsut")
    public suspend fun retentionPeriod(`value`: Output<Int>) {
        this.retentionPeriod = value
    }

    /**
     * @param value The destination region that you want to copy snapshots to.
     */
    @JvmName("oeuuqrpjwlqmiygq")
    public suspend fun destinationRegion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationRegion = mapped
    }

    /**
     * @param value The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
     */
    @JvmName("wmhrwbwwncgsxmie")
    public suspend fun grantName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grantName = mapped
    }

    /**
     * @param value The number of days to retain automated snapshots in the destination region after they are copied from the source region. Defaults to `7`.
     */
    @JvmName("mxpmpyvenonstgtq")
    public suspend fun retentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriod = mapped
    }

    internal fun build(): ClusterSnapshotCopyArgs = ClusterSnapshotCopyArgs(
        destinationRegion = destinationRegion ?: throw PulumiNullFieldException("destinationRegion"),
        grantName = grantName,
        retentionPeriod = retentionPeriod,
    )
}
