@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.inputs

import com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionPauseClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterIdentifier The identifier of the cluster to be paused.
 */
public data class ScheduledActionTargetActionPauseClusterArgs(
    public val clusterIdentifier: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionPauseClusterArgs> {
    override fun toJava(): com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionPauseClusterArgs =
        com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionPauseClusterArgs.builder()
            .clusterIdentifier(clusterIdentifier.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduledActionTargetActionPauseClusterArgs].
 */
@PulumiTagMarker
public class ScheduledActionTargetActionPauseClusterArgsBuilder internal constructor() {
    private var clusterIdentifier: Output<String>? = null

    /**
     * @param value The identifier of the cluster to be paused.
     */
    @JvmName("jqupddrjbdytxsyt")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The identifier of the cluster to be paused.
     */
    @JvmName("vxdinjsvayjsyoii")
    public suspend fun clusterIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    internal fun build(): ScheduledActionTargetActionPauseClusterArgs =
        ScheduledActionTargetActionPauseClusterArgs(
            clusterIdentifier = clusterIdentifier ?: throw PulumiNullFieldException("clusterIdentifier"),
        )
}
