@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destinationRegion The destination region that you want to copy snapshots to.
 * @property grantName The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
 * @property retentionPeriod The number of days to retain automated snapshots in the destination region after they are copied from the source region. Defaults to `7`.
 */
public data class ClusterSnapshotCopy(
    public val destinationRegion: String,
    public val grantName: String? = null,
    public val retentionPeriod: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.ClusterSnapshotCopy):
            ClusterSnapshotCopy = ClusterSnapshotCopy(
            destinationRegion = javaType.destinationRegion(),
            grantName = javaType.grantName().map({ args0 -> args0 }).orElse(null),
            retentionPeriod = javaType.retentionPeriod().map({ args0 -> args0 }).orElse(null),
        )
    }
}
