@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property networkInterfaces One or more network interfaces of the endpoint. Also known as an interface endpoint. See details below.
 * @property vpcEndpointId The connection endpoint ID for connecting an Amazon Redshift cluster through the proxy.
 * @property vpcId The VPC identifier that the endpoint is associated.
 */
public data class EndpointAccessVpcEndpoint(
    public val networkInterfaces: List<EndpointAccessVpcEndpointNetworkInterface>? = null,
    public val vpcEndpointId: String? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.EndpointAccessVpcEndpoint):
            EndpointAccessVpcEndpoint = EndpointAccessVpcEndpoint(
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.redshift.kotlin.outputs.EndpointAccessVpcEndpointNetworkInterface.Companion.toKotlin(args0)
                })
            }),
            vpcEndpointId = javaType.vpcEndpointId().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
