@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property nodeRole Whether the node is a leader node or a compute node
 * @property privateIpAddress Private IP address of a node within a cluster
 * @property publicIpAddress Public IP address of a node within a cluster
 */
public data class GetClusterClusterNode(
    public val nodeRole: String,
    public val privateIpAddress: String,
    public val publicIpAddress: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.GetClusterClusterNode):
            GetClusterClusterNode = GetClusterClusterNode(
            nodeRole = javaType.nodeRole(),
            privateIpAddress = javaType.privateIpAddress(),
            publicIpAddress = javaType.publicIpAddress(),
        )
    }
}
