@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getClusterCredentials.
 * @property autoCreate
 * @property clusterIdentifier
 * @property dbGroups
 * @property dbName
 * @property dbPassword Temporary password that authorizes the user name returned by `db_user` to log on to the database `db_name`.
 * @property dbUser
 * @property durationSeconds
 * @property expiration Date and time the password in `db_password` expires.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetClusterCredentialsResult(
    public val autoCreate: Boolean? = null,
    public val clusterIdentifier: String,
    public val dbGroups: List<String>? = null,
    public val dbName: String? = null,
    public val dbPassword: String,
    public val dbUser: String,
    public val durationSeconds: Int? = null,
    public val expiration: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.GetClusterCredentialsResult):
            GetClusterCredentialsResult = GetClusterCredentialsResult(
            autoCreate = javaType.autoCreate().map({ args0 -> args0 }).orElse(null),
            clusterIdentifier = javaType.clusterIdentifier(),
            dbGroups = javaType.dbGroups().map({ args0 -> args0 }),
            dbName = javaType.dbName().map({ args0 -> args0 }).orElse(null),
            dbPassword = javaType.dbPassword(),
            dbUser = javaType.dbUser(),
            durationSeconds = javaType.durationSeconds().map({ args0 -> args0 }).orElse(null),
            expiration = javaType.expiration(),
            id = javaType.id(),
        )
    }
}
