@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOrderableCluster.
 * @property availabilityZones List of Availability Zone names where the Redshift Cluster is available.
 * @property clusterType
 * @property clusterVersion
 * @property id The provider-assigned unique ID for this managed resource.
 * @property nodeType
 * @property preferredNodeTypes
 */
public data class GetOrderableClusterResult(
    public val availabilityZones: List<String>,
    public val clusterType: String,
    public val clusterVersion: String,
    public val id: String,
    public val nodeType: String,
    public val preferredNodeTypes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.GetOrderableClusterResult):
            GetOrderableClusterResult = GetOrderableClusterResult(
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            clusterType = javaType.clusterType(),
            clusterVersion = javaType.clusterVersion(),
            id = javaType.id(),
            nodeType = javaType.nodeType(),
            preferredNodeTypes = javaType.preferredNodeTypes().map({ args0 -> args0 }),
        )
    }
}
