@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property pauseCluster An action that runs a `PauseCluster` API operation. Documented below.
 * @property resizeCluster An action that runs a `ResizeCluster` API operation. Documented below.
 * @property resumeCluster An action that runs a `ResumeCluster` API operation. Documented below.
 */
public data class ScheduledActionTargetAction(
    public val pauseCluster: ScheduledActionTargetActionPauseCluster? = null,
    public val resizeCluster: ScheduledActionTargetActionResizeCluster? = null,
    public val resumeCluster: ScheduledActionTargetActionResumeCluster? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.ScheduledActionTargetAction):
            ScheduledActionTargetAction = ScheduledActionTargetAction(
            pauseCluster = javaType.pauseCluster().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.redshift.kotlin.outputs.ScheduledActionTargetActionPauseCluster.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resizeCluster = javaType.resizeCluster().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.redshift.kotlin.outputs.ScheduledActionTargetActionResizeCluster.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resumeCluster = javaType.resumeCluster().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.redshift.kotlin.outputs.ScheduledActionTargetActionResumeCluster.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
