@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshift.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property classic A boolean value indicating whether the resize operation is using the classic resize process. Default: `false`.
 * @property clusterIdentifier The unique identifier for the cluster to resize.
 * @property clusterType The new cluster type for the specified cluster.
 * @property nodeType The new node type for the nodes you are adding.
 * @property numberOfNodes The new number of nodes for the cluster.
 */
public data class ScheduledActionTargetActionResizeCluster(
    public val classic: Boolean? = null,
    public val clusterIdentifier: String,
    public val clusterType: String? = null,
    public val nodeType: String? = null,
    public val numberOfNodes: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.redshift.outputs.ScheduledActionTargetActionResizeCluster):
            ScheduledActionTargetActionResizeCluster = ScheduledActionTargetActionResizeCluster(
            classic = javaType.classic().map({ args0 -> args0 }).orElse(null),
            clusterIdentifier = javaType.clusterIdentifier(),
            clusterType = javaType.clusterType().map({ args0 -> args0 }).orElse(null),
            nodeType = javaType.nodeType().map({ args0 -> args0 }).orElse(null),
            numberOfNodes = javaType.numberOfNodes().map({ args0 -> args0 }).orElse(null),
        )
    }
}
