@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftdata.kotlin

import com.pulumi.aws.redshiftdata.StatementArgs.builder
import com.pulumi.aws.redshiftdata.kotlin.inputs.StatementParameterArgs
import com.pulumi.aws.redshiftdata.kotlin.inputs.StatementParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Executes a Redshift Data Statement.
 * ## Example Usage
 * ### cluster_identifier
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftdata.Statement;
 * import com.pulumi.aws.redshiftdata.StatementArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Statement("example", StatementArgs.builder()
 *             .clusterIdentifier(aws_redshift_cluster.example().cluster_identifier())
 *             .database(aws_redshift_cluster.example().database_name())
 *             .dbUser(aws_redshift_cluster.example().master_username())
 *             .sql("CREATE GROUP group_name;")
 *             .build());
 *     }
 * }
 * ```
 * ### workgroup_name
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftdata.Statement;
 * import com.pulumi.aws.redshiftdata.StatementArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Statement("example", StatementArgs.builder()
 *             .workgroupName(aws_redshiftserverless_workgroup.example().workgroup_name())
 *             .database("dev")
 *             .sql("CREATE GROUP group_name;")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Data Statements using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:redshiftdata/statement:Statement example example
 * ```
 * @property clusterIdentifier The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
 * @property database The name of the database.
 * @property dbUser The database user name.
 * @property parameters
 * @property secretArn The name or ARN of the secret that enables access to the database.
 * @property sql The SQL statement text to run.
 * The following arguments are optional:
 * @property statementName The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
 * @property withEvent A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
 * @property workgroupName The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
 */
public data class StatementArgs(
    public val clusterIdentifier: Output<String>? = null,
    public val database: Output<String>? = null,
    public val dbUser: Output<String>? = null,
    public val parameters: Output<List<StatementParameterArgs>>? = null,
    public val secretArn: Output<String>? = null,
    public val sql: Output<String>? = null,
    public val statementName: Output<String>? = null,
    public val withEvent: Output<Boolean>? = null,
    public val workgroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshiftdata.StatementArgs> {
    override fun toJava(): com.pulumi.aws.redshiftdata.StatementArgs =
        com.pulumi.aws.redshiftdata.StatementArgs.builder()
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .database(database?.applyValue({ args0 -> args0 }))
            .dbUser(dbUser?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .secretArn(secretArn?.applyValue({ args0 -> args0 }))
            .sql(sql?.applyValue({ args0 -> args0 }))
            .statementName(statementName?.applyValue({ args0 -> args0 }))
            .withEvent(withEvent?.applyValue({ args0 -> args0 }))
            .workgroupName(workgroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StatementArgs].
 */
@PulumiTagMarker
public class StatementArgsBuilder internal constructor() {
    private var clusterIdentifier: Output<String>? = null

    private var database: Output<String>? = null

    private var dbUser: Output<String>? = null

    private var parameters: Output<List<StatementParameterArgs>>? = null

    private var secretArn: Output<String>? = null

    private var sql: Output<String>? = null

    private var statementName: Output<String>? = null

    private var withEvent: Output<Boolean>? = null

    private var workgroupName: Output<String>? = null

    /**
     * @param value The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
     */
    @JvmName("hqtsnkobmegtayyh")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("pquybotfnqatmhxt")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value The database user name.
     */
    @JvmName("yreroafymfldmykw")
    public suspend fun dbUser(`value`: Output<String>) {
        this.dbUser = value
    }

    /**
     * @param value
     */
    @JvmName("hiwfmitdohqgftwq")
    public suspend fun parameters(`value`: Output<List<StatementParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("jldfikbteahsmgcw")
    public suspend fun parameters(vararg values: Output<StatementParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ikqwoxahtfrjxmug")
    public suspend fun parameters(values: List<Output<StatementParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The name or ARN of the secret that enables access to the database.
     */
    @JvmName("ocnbgwwbjpafndtf")
    public suspend fun secretArn(`value`: Output<String>) {
        this.secretArn = value
    }

    /**
     * @param value The SQL statement text to run.
     * The following arguments are optional:
     */
    @JvmName("hmqhnvkuuvpqsopb")
    public suspend fun sql(`value`: Output<String>) {
        this.sql = value
    }

    /**
     * @param value The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     */
    @JvmName("ovdvdkwvfqolajev")
    public suspend fun statementName(`value`: Output<String>) {
        this.statementName = value
    }

    /**
     * @param value A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
     */
    @JvmName("kthmllulxnfsavbf")
    public suspend fun withEvent(`value`: Output<Boolean>) {
        this.withEvent = value
    }

    /**
     * @param value The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
     */
    @JvmName("uliqfxtpqxdifjsr")
    public suspend fun workgroupName(`value`: Output<String>) {
        this.workgroupName = value
    }

    /**
     * @param value The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials.
     */
    @JvmName("rlivkwfawwcepihy")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("hbtmxkreqsiaigmu")
    public suspend fun database(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value The database user name.
     */
    @JvmName("slsnlvpttscudmfy")
    public suspend fun dbUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbUser = mapped
    }

    /**
     * @param value
     */
    @JvmName("lfmrpftlfsnwduxf")
    public suspend fun parameters(`value`: List<StatementParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xnspcdtroqaeeoeh")
    public suspend fun parameters(argument: List<suspend StatementParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StatementParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ymahmgojlrvrjhoq")
    public suspend fun parameters(vararg argument: suspend StatementParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StatementParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ffwkmpwnsfaltdhw")
    public suspend fun parameters(argument: suspend StatementParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StatementParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values
     */
    @JvmName("tpkedyjnifrfjidv")
    public suspend fun parameters(vararg values: StatementParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The name or ARN of the secret that enables access to the database.
     */
    @JvmName("lothjrkjyatjfxmu")
    public suspend fun secretArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretArn = mapped
    }

    /**
     * @param value The SQL statement text to run.
     * The following arguments are optional:
     */
    @JvmName("kiqtinaoctcqatjn")
    public suspend fun sql(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sql = mapped
    }

    /**
     * @param value The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     */
    @JvmName("flonuedfediawxpw")
    public suspend fun statementName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statementName = mapped
    }

    /**
     * @param value A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
     */
    @JvmName("dbboudpkmoaerqhf")
    public suspend fun withEvent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.withEvent = mapped
    }

    /**
     * @param value The serverless workgroup name. This parameter is required when connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
     */
    @JvmName("akvctscnquiiasve")
    public suspend fun workgroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workgroupName = mapped
    }

    internal fun build(): StatementArgs = StatementArgs(
        clusterIdentifier = clusterIdentifier,
        database = database,
        dbUser = dbUser,
        parameters = parameters,
        secretArn = secretArn,
        sql = sql,
        statementName = statementName,
        withEvent = withEvent,
        workgroupName = workgroupName,
    )
}
