@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.aws.redshiftserverless.EndpointAccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Serverless Endpoint Access.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.EndpointAccess;
 * import com.pulumi.aws.redshiftserverless.EndpointAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EndpointAccess("example", EndpointAccessArgs.builder()
 *             .endpointName("example")
 *             .workgroupName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Endpoint Access using the `endpoint_name`. For example:
 * ```sh
 *  $ pulumi import aws:redshiftserverless/endpointAccess:EndpointAccess example example
 * ```
 * @property endpointName The name of the endpoint.
 * @property subnetIds An array of VPC subnet IDs to associate with the endpoint.
 * @property vpcSecurityGroupIds An array of security group IDs to associate with the workgroup.
 * @property workgroupName The name of the workgroup.
 */
public data class EndpointAccessArgs(
    public val endpointName: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
    public val workgroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.EndpointAccessArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.EndpointAccessArgs =
        com.pulumi.aws.redshiftserverless.EndpointAccessArgs.builder()
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcSecurityGroupIds(vpcSecurityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .workgroupName(workgroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointAccessArgs].
 */
@PulumiTagMarker
public class EndpointAccessArgsBuilder internal constructor() {
    private var endpointName: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    private var workgroupName: Output<String>? = null

    /**
     * @param value The name of the endpoint.
     */
    @JvmName("kevbhvloxvvxawjl")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value An array of VPC subnet IDs to associate with the endpoint.
     */
    @JvmName("ewsmvxdgxxvoytod")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("cofjlfigdpsohaaa")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values An array of VPC subnet IDs to associate with the endpoint.
     */
    @JvmName("ghifqbncrfggmwts")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value An array of security group IDs to associate with the workgroup.
     */
    @JvmName("jlgpvdmwsjbmxyxy")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("cuwdccgjgcndbcsv")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values An array of security group IDs to associate with the workgroup.
     */
    @JvmName("whondntyuwrfsjqq")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value The name of the workgroup.
     */
    @JvmName("dcrrgfmtxlyncjdv")
    public suspend fun workgroupName(`value`: Output<String>) {
        this.workgroupName = value
    }

    /**
     * @param value The name of the endpoint.
     */
    @JvmName("fqrawquntgrhanot")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value An array of VPC subnet IDs to associate with the endpoint.
     */
    @JvmName("gyjyifmjgrpktpac")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values An array of VPC subnet IDs to associate with the endpoint.
     */
    @JvmName("bflbmcwwlcuargsb")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value An array of security group IDs to associate with the workgroup.
     */
    @JvmName("cinfgewomissywad")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values An array of security group IDs to associate with the workgroup.
     */
    @JvmName("ocsilgiesokvbdyx")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param value The name of the workgroup.
     */
    @JvmName("inodhryyadqinbap")
    public suspend fun workgroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workgroupName = mapped
    }

    internal fun build(): EndpointAccessArgs = EndpointAccessArgs(
        endpointName = endpointName,
        subnetIds = subnetIds,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
        workgroupName = workgroupName,
    )
}
