@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.aws.redshiftserverless.NamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Serverless Namespace.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.Namespace;
 * import com.pulumi.aws.redshiftserverless.NamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Namespace("example", NamespaceArgs.builder()
 *             .namespaceName("concurrency-scaling")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Namespaces using the `namespace_name`. For example:
 * ```sh
 *  $ pulumi import aws:redshiftserverless/namespace:Namespace example example
 * ```
 * @property adminUserPassword The password of the administrator for the first database created in the namespace.
 * @property adminUsername The username of the administrator for the first database created in the namespace.
 * @property dbName The name of the first database created in the namespace.
 * @property defaultIamRoleArn The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. When specifying `default_iam_role_arn`, it also must be part of `iam_roles`.
 * @property iamRoles A list of IAM roles to associate with the namespace.
 * @property kmsKeyId The ARN of the Amazon Web Services Key Management Service key used to encrypt your data.
 * @property logExports The types of logs the namespace can export. Available export types are `userlog`, `connectionlog`, and `useractivitylog`.
 * @property namespaceName The name of the namespace.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class NamespaceArgs(
    public val adminUserPassword: Output<String>? = null,
    public val adminUsername: Output<String>? = null,
    public val dbName: Output<String>? = null,
    public val defaultIamRoleArn: Output<String>? = null,
    public val iamRoles: Output<List<String>>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val logExports: Output<List<String>>? = null,
    public val namespaceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.NamespaceArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.NamespaceArgs =
        com.pulumi.aws.redshiftserverless.NamespaceArgs.builder()
            .adminUserPassword(adminUserPassword?.applyValue({ args0 -> args0 }))
            .adminUsername(adminUsername?.applyValue({ args0 -> args0 }))
            .dbName(dbName?.applyValue({ args0 -> args0 }))
            .defaultIamRoleArn(defaultIamRoleArn?.applyValue({ args0 -> args0 }))
            .iamRoles(iamRoles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .logExports(logExports?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NamespaceArgs].
 */
@PulumiTagMarker
public class NamespaceArgsBuilder internal constructor() {
    private var adminUserPassword: Output<String>? = null

    private var adminUsername: Output<String>? = null

    private var dbName: Output<String>? = null

    private var defaultIamRoleArn: Output<String>? = null

    private var iamRoles: Output<List<String>>? = null

    private var kmsKeyId: Output<String>? = null

    private var logExports: Output<List<String>>? = null

    private var namespaceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The password of the administrator for the first database created in the namespace.
     */
    @JvmName("glghpeellmvkhrdo")
    public suspend fun adminUserPassword(`value`: Output<String>) {
        this.adminUserPassword = value
    }

    /**
     * @param value The username of the administrator for the first database created in the namespace.
     */
    @JvmName("fcapdcrfrnabwcwo")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value The name of the first database created in the namespace.
     */
    @JvmName("cfpolvgqfyaswxkr")
    public suspend fun dbName(`value`: Output<String>) {
        this.dbName = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. When specifying `default_iam_role_arn`, it also must be part of `iam_roles`.
     */
    @JvmName("qwfvtjyshobmtvvt")
    public suspend fun defaultIamRoleArn(`value`: Output<String>) {
        this.defaultIamRoleArn = value
    }

    /**
     * @param value A list of IAM roles to associate with the namespace.
     */
    @JvmName("hemljvbncjfbfexk")
    public suspend fun iamRoles(`value`: Output<List<String>>) {
        this.iamRoles = value
    }

    @JvmName("kwjdikeswkjulffl")
    public suspend fun iamRoles(vararg values: Output<String>) {
        this.iamRoles = Output.all(values.asList())
    }

    /**
     * @param values A list of IAM roles to associate with the namespace.
     */
    @JvmName("wrbjbxpmeudnirto")
    public suspend fun iamRoles(values: List<Output<String>>) {
        this.iamRoles = Output.all(values)
    }

    /**
     * @param value The ARN of the Amazon Web Services Key Management Service key used to encrypt your data.
     */
    @JvmName("nsfnvbhumloracsw")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The types of logs the namespace can export. Available export types are `userlog`, `connectionlog`, and `useractivitylog`.
     */
    @JvmName("embvscjjsqnlhrks")
    public suspend fun logExports(`value`: Output<List<String>>) {
        this.logExports = value
    }

    @JvmName("mqsoxinmnnjtwbhb")
    public suspend fun logExports(vararg values: Output<String>) {
        this.logExports = Output.all(values.asList())
    }

    /**
     * @param values The types of logs the namespace can export. Available export types are `userlog`, `connectionlog`, and `useractivitylog`.
     */
    @JvmName("nbrlnbpyyhwbkwgo")
    public suspend fun logExports(values: List<Output<String>>) {
        this.logExports = Output.all(values)
    }

    /**
     * @param value The name of the namespace.
     */
    @JvmName("otytjspakymlnimc")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kftahvfdrhjkngyg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The password of the administrator for the first database created in the namespace.
     */
    @JvmName("aagfhpofpytlamrl")
    public suspend fun adminUserPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUserPassword = mapped
    }

    /**
     * @param value The username of the administrator for the first database created in the namespace.
     */
    @JvmName("gwdbhckwnurylval")
    public suspend fun adminUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value The name of the first database created in the namespace.
     */
    @JvmName("rcnqqwmydxlncboe")
    public suspend fun dbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbName = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. When specifying `default_iam_role_arn`, it also must be part of `iam_roles`.
     */
    @JvmName("xvbljiqcwabyopxl")
    public suspend fun defaultIamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultIamRoleArn = mapped
    }

    /**
     * @param value A list of IAM roles to associate with the namespace.
     */
    @JvmName("uqdgsubnhamewacr")
    public suspend fun iamRoles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoles = mapped
    }

    /**
     * @param values A list of IAM roles to associate with the namespace.
     */
    @JvmName("uypnrxnddcujkvig")
    public suspend fun iamRoles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iamRoles = mapped
    }

    /**
     * @param value The ARN of the Amazon Web Services Key Management Service key used to encrypt your data.
     */
    @JvmName("hfyubcbyncwpndwy")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The types of logs the namespace can export. Available export types are `userlog`, `connectionlog`, and `useractivitylog`.
     */
    @JvmName("vbmlqtkvicsmtrnd")
    public suspend fun logExports(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logExports = mapped
    }

    /**
     * @param values The types of logs the namespace can export. Available export types are `userlog`, `connectionlog`, and `useractivitylog`.
     */
    @JvmName("gtaiircburxxkdya")
    public suspend fun logExports(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logExports = mapped
    }

    /**
     * @param value The name of the namespace.
     */
    @JvmName("dqyyahayajggorgv")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yqywcouqkkdfwmkx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hgjtyyxsygfywaqy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NamespaceArgs = NamespaceArgs(
        adminUserPassword = adminUserPassword,
        adminUsername = adminUsername,
        dbName = dbName,
        defaultIamRoleArn = defaultIamRoleArn,
        iamRoles = iamRoles,
        kmsKeyId = kmsKeyId,
        logExports = logExports,
        namespaceName = namespaceName,
        tags = tags,
    )
}
