@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ResourcePolicy].
 */
@PulumiTagMarker
public class ResourcePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourcePolicyArgs = ResourcePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourcePolicyArgsBuilder.() -> Unit) {
        val builder = ResourcePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResourcePolicy {
        val builtJavaResource =
            com.pulumi.aws.redshiftserverless.ResourcePolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ResourcePolicy(builtJavaResource)
    }
}

/**
 * Creates a new Amazon Redshift Serverless Resource Policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.ResourcePolicy;
 * import com.pulumi.aws.redshiftserverless.ResourcePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourcePolicy("example", ResourcePolicyArgs.builder()
 *             .resourceArn(aws_redshiftserverless_snapshot.example().arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", jsonArray("12345678901"))
 *                         )),
 *                         jsonProperty("Action", jsonArray("redshift-serverless:RestoreFromSnapshot")),
 *                         jsonProperty("Sid", "")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Resource Policies using the `resource_arn`. For example:
 * ```sh
 *  $ pulumi import aws:redshiftserverless/resourcePolicy:ResourcePolicy example example
 * ```
 *
 */
public class ResourcePolicy internal constructor(
    override val javaResource: com.pulumi.aws.redshiftserverless.ResourcePolicy,
) : KotlinCustomResource(javaResource, ResourcePolicyMapper) {
    /**
     * The policy to create or update. For example, the following policy grants a user authorization to restore a snapshot.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the account to create or update a resource policy for.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })
}

public object ResourcePolicyMapper : ResourceMapper<ResourcePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshiftserverless.ResourcePolicy::class == javaResource::class

    override fun map(javaResource: Resource): ResourcePolicy = ResourcePolicy(
        javaResource as
            com.pulumi.aws.redshiftserverless.ResourcePolicy,
    )
}

/**
 * @see [ResourcePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourcePolicy].
 */
public suspend fun resourcePolicy(
    name: String,
    block: suspend ResourcePolicyResourceBuilder.() -> Unit,
): ResourcePolicy {
    val builder = ResourcePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourcePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourcePolicy(name: String): ResourcePolicy {
    val builder = ResourcePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
