@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.aws.redshiftserverless.ResourcePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Serverless Resource Policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.ResourcePolicy;
 * import com.pulumi.aws.redshiftserverless.ResourcePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourcePolicy("example", ResourcePolicyArgs.builder()
 *             .resourceArn(aws_redshiftserverless_snapshot.example().arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", jsonArray("12345678901"))
 *                         )),
 *                         jsonProperty("Action", jsonArray("redshift-serverless:RestoreFromSnapshot")),
 *                         jsonProperty("Sid", "")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Resource Policies using the `resource_arn`. For example:
 * ```sh
 *  $ pulumi import aws:redshiftserverless/resourcePolicy:ResourcePolicy example example
 * ```
 * @property policy The policy to create or update. For example, the following policy grants a user authorization to restore a snapshot.
 * @property resourceArn The Amazon Resource Name (ARN) of the account to create or update a resource policy for.
 */
public data class ResourcePolicyArgs(
    public val policy: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.ResourcePolicyArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.ResourcePolicyArgs =
        com.pulumi.aws.redshiftserverless.ResourcePolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourcePolicyArgs].
 */
@PulumiTagMarker
public class ResourcePolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value The policy to create or update. For example, the following policy grants a user authorization to restore a snapshot.
     */
    @JvmName("rxoamucxmmbllmpu")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the account to create or update a resource policy for.
     */
    @JvmName("otlgdhddfvhmemmo")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The policy to create or update. For example, the following policy grants a user authorization to restore a snapshot.
     */
    @JvmName("qaryucpxtsbwxsxb")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the account to create or update a resource policy for.
     */
    @JvmName("cscmgfpqnkjewgbh")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): ResourcePolicyArgs = ResourcePolicyArgs(
        policy = policy,
        resourceArn = resourceArn,
    )
}
