@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UsageLimit].
 */
@PulumiTagMarker
public class UsageLimitResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UsageLimitArgs = UsageLimitArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UsageLimitArgsBuilder.() -> Unit) {
        val builder = UsageLimitArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UsageLimit {
        val builtJavaResource = com.pulumi.aws.redshiftserverless.UsageLimit(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UsageLimit(builtJavaResource)
    }
}

/**
 * Creates a new Amazon Redshift Serverless Usage Limit.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.Workgroup;
 * import com.pulumi.aws.redshiftserverless.WorkgroupArgs;
 * import com.pulumi.aws.redshiftserverless.UsageLimit;
 * import com.pulumi.aws.redshiftserverless.UsageLimitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleWorkgroup = new Workgroup("exampleWorkgroup", WorkgroupArgs.builder()
 *             .namespaceName(aws_redshiftserverless_namespace.example().namespace_name())
 *             .workgroupName("example")
 *             .build());
 *         var exampleUsageLimit = new UsageLimit("exampleUsageLimit", UsageLimitArgs.builder()
 *             .resourceArn(exampleWorkgroup.arn())
 *             .usageType("serverless-compute")
 *             .amount(60)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Usage Limits using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:redshiftserverless/usageLimit:UsageLimit example example-id
 * ```
 *
 */
public class UsageLimit internal constructor(
    override val javaResource: com.pulumi.aws.redshiftserverless.UsageLimit,
) : KotlinCustomResource(javaResource, UsageLimitMapper) {
    /**
     * The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
     */
    public val amount: Output<Int>
        get() = javaResource.amount().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the Redshift Serverless Usage Limit.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
     */
    public val breachAction: Output<String>?
        get() = javaResource.breachAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
     */
    public val period: Output<String>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
     */
    public val usageType: Output<String>
        get() = javaResource.usageType().applyValue({ args0 -> args0 })
}

public object UsageLimitMapper : ResourceMapper<UsageLimit> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshiftserverless.UsageLimit::class == javaResource::class

    override fun map(javaResource: Resource): UsageLimit = UsageLimit(
        javaResource as
            com.pulumi.aws.redshiftserverless.UsageLimit,
    )
}

/**
 * @see [UsageLimit].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UsageLimit].
 */
public suspend fun usageLimit(name: String, block: suspend UsageLimitResourceBuilder.() -> Unit):
    UsageLimit {
    val builder = UsageLimitResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UsageLimit].
 * @param name The _unique_ name of the resulting resource.
 */
public fun usageLimit(name: String): UsageLimit {
    val builder = UsageLimitResourceBuilder()
    builder.name(name)
    return builder.build()
}
