@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.aws.redshiftserverless.UsageLimitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Serverless Usage Limit.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.Workgroup;
 * import com.pulumi.aws.redshiftserverless.WorkgroupArgs;
 * import com.pulumi.aws.redshiftserverless.UsageLimit;
 * import com.pulumi.aws.redshiftserverless.UsageLimitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleWorkgroup = new Workgroup("exampleWorkgroup", WorkgroupArgs.builder()
 *             .namespaceName(aws_redshiftserverless_namespace.example().namespace_name())
 *             .workgroupName("example")
 *             .build());
 *         var exampleUsageLimit = new UsageLimit("exampleUsageLimit", UsageLimitArgs.builder()
 *             .resourceArn(exampleWorkgroup.arn())
 *             .usageType("serverless-compute")
 *             .amount(60)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Usage Limits using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:redshiftserverless/usageLimit:UsageLimit example example-id
 * ```
 * @property amount The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
 * @property breachAction The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
 * @property period The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
 * @property resourceArn The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
 * @property usageType The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
 */
public data class UsageLimitArgs(
    public val amount: Output<Int>? = null,
    public val breachAction: Output<String>? = null,
    public val period: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
    public val usageType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.UsageLimitArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.UsageLimitArgs =
        com.pulumi.aws.redshiftserverless.UsageLimitArgs.builder()
            .amount(amount?.applyValue({ args0 -> args0 }))
            .breachAction(breachAction?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 }))
            .usageType(usageType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UsageLimitArgs].
 */
@PulumiTagMarker
public class UsageLimitArgsBuilder internal constructor() {
    private var amount: Output<Int>? = null

    private var breachAction: Output<String>? = null

    private var period: Output<String>? = null

    private var resourceArn: Output<String>? = null

    private var usageType: Output<String>? = null

    /**
     * @param value The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
     */
    @JvmName("tyqokwwokorlrogt")
    public suspend fun amount(`value`: Output<Int>) {
        this.amount = value
    }

    /**
     * @param value The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
     */
    @JvmName("saxbqlbbloiebscq")
    public suspend fun breachAction(`value`: Output<String>) {
        this.breachAction = value
    }

    /**
     * @param value The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
     */
    @JvmName("cebwrhbhttwpmojb")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
     */
    @JvmName("yaitycndhmgmlfuf")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
     */
    @JvmName("jtvycthonbjsfyab")
    public suspend fun usageType(`value`: Output<String>) {
        this.usageType = value
    }

    /**
     * @param value The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.
     */
    @JvmName("dwooastiynybggil")
    public suspend fun amount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amount = mapped
    }

    /**
     * @param value The action that Amazon Redshift Serverless takes when the limit is reached. Valid values are `log`, `emit-metric`, and `deactivate`. The default is `log`.
     */
    @JvmName("akasojsxjyxsjegb")
    public suspend fun breachAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.breachAction = mapped
    }

    /**
     * @param value The time period that the amount applies to. A weekly period begins on Sunday. Valid values are `daily`, `weekly`, and `monthly`. The default is `monthly`.
     */
    @JvmName("blifsawaxwhaprfq")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.
     */
    @JvmName("cckemsbwjhcgngwj")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    /**
     * @param value The type of Amazon Redshift Serverless usage to create a usage limit for. Valid values are `serverless-compute` or `cross-region-datasharing`.
     */
    @JvmName("mcwgrqhvnnsoslar")
    public suspend fun usageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usageType = mapped
    }

    internal fun build(): UsageLimitArgs = UsageLimitArgs(
        amount = amount,
        breachAction = breachAction,
        period = period,
        resourceArn = resourceArn,
        usageType = usageType,
    )
}
