@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.aws.redshiftserverless.kotlin.outputs.WorkgroupConfigParameter
import com.pulumi.aws.redshiftserverless.kotlin.outputs.WorkgroupEndpoint
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.redshiftserverless.kotlin.outputs.WorkgroupConfigParameter.Companion.toKotlin as workgroupConfigParameterToKotlin
import com.pulumi.aws.redshiftserverless.kotlin.outputs.WorkgroupEndpoint.Companion.toKotlin as workgroupEndpointToKotlin

/**
 * Builder for [Workgroup].
 */
@PulumiTagMarker
public class WorkgroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkgroupArgs = WorkgroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkgroupArgsBuilder.() -> Unit) {
        val builder = WorkgroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Workgroup {
        val builtJavaResource = com.pulumi.aws.redshiftserverless.Workgroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workgroup(builtJavaResource)
    }
}

/**
 * Creates a new Amazon Redshift Serverless Workgroup.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.Workgroup;
 * import com.pulumi.aws.redshiftserverless.WorkgroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workgroup("example", WorkgroupArgs.builder()
 *             .namespaceName("concurrency-scaling")
 *             .workgroupName("concurrency-scaling")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Workgroups using the `workgroup_name`. For example:
 * ```sh
 *  $ pulumi import aws:redshiftserverless/workgroup:Workgroup example example
 * ```
 *
 */
public class Workgroup internal constructor(
    override val javaResource: com.pulumi.aws.redshiftserverless.Workgroup,
) : KotlinCustomResource(javaResource, WorkgroupMapper) {
    /**
     * Amazon Resource Name (ARN) of the Redshift Serverless Workgroup.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
     */
    public val baseCapacity: Output<Int>
        get() = javaResource.baseCapacity().applyValue({ args0 -> args0 })

    /**
     * An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    public val configParameters: Output<List<WorkgroupConfigParameter>>
        get() = javaResource.configParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> workgroupConfigParameterToKotlin(args0) })
            })
        })

    /**
     * The endpoint that is created from the workgroup. See `Endpoint` below.
     */
    public val endpoints: Output<List<WorkgroupEndpoint>>
        get() = javaResource.endpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    workgroupEndpointToKotlin(args0)
                })
            })
        })

    /**
     * The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
     */
    public val enhancedVpcRouting: Output<Boolean>?
        get() = javaResource.enhancedVpcRouting().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the namespace.
     */
    public val namespaceName: Output<String>
        get() = javaResource.namespaceName().applyValue({ args0 -> args0 })

    /**
     * A value that specifies whether the workgroup can be accessed from a public network.
     */
    public val publiclyAccessible: Output<Boolean>?
        get() = javaResource.publiclyAccessible().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An array of security group IDs to associate with the workgroup.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Redshift Workgroup ID.
     */
    public val workgroupId: Output<String>
        get() = javaResource.workgroupId().applyValue({ args0 -> args0 })

    /**
     * The name of the workgroup.
     * The following arguments are optional:
     */
    public val workgroupName: Output<String>
        get() = javaResource.workgroupName().applyValue({ args0 -> args0 })
}

public object WorkgroupMapper : ResourceMapper<Workgroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.redshiftserverless.Workgroup::class == javaResource::class

    override fun map(javaResource: Resource): Workgroup = Workgroup(
        javaResource as
            com.pulumi.aws.redshiftserverless.Workgroup,
    )
}

/**
 * @see [Workgroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workgroup].
 */
public suspend fun workgroup(name: String, block: suspend WorkgroupResourceBuilder.() -> Unit):
    Workgroup {
    val builder = WorkgroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workgroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workgroup(name: String): Workgroup {
    val builder = WorkgroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
