@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin

import com.pulumi.aws.redshiftserverless.WorkgroupArgs.builder
import com.pulumi.aws.redshiftserverless.kotlin.inputs.WorkgroupConfigParameterArgs
import com.pulumi.aws.redshiftserverless.kotlin.inputs.WorkgroupConfigParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a new Amazon Redshift Serverless Workgroup.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.Workgroup;
 * import com.pulumi.aws.redshiftserverless.WorkgroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workgroup("example", WorkgroupArgs.builder()
 *             .namespaceName("concurrency-scaling")
 *             .workgroupName("concurrency-scaling")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Redshift Serverless Workgroups using the `workgroup_name`. For example:
 * ```sh
 *  $ pulumi import aws:redshiftserverless/workgroup:Workgroup example example
 * ```
 * @property baseCapacity The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
 * @property configParameters An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
 * @property enhancedVpcRouting The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
 * @property namespaceName The name of the namespace.
 * @property publiclyAccessible A value that specifies whether the workgroup can be accessed from a public network.
 * @property securityGroupIds An array of security group IDs to associate with the workgroup.
 * @property subnetIds An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property workgroupName The name of the workgroup.
 * The following arguments are optional:
 */
public data class WorkgroupArgs(
    public val baseCapacity: Output<Int>? = null,
    public val configParameters: Output<List<WorkgroupConfigParameterArgs>>? = null,
    public val enhancedVpcRouting: Output<Boolean>? = null,
    public val namespaceName: Output<String>? = null,
    public val publiclyAccessible: Output<Boolean>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workgroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.WorkgroupArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.WorkgroupArgs =
        com.pulumi.aws.redshiftserverless.WorkgroupArgs.builder()
            .baseCapacity(baseCapacity?.applyValue({ args0 -> args0 }))
            .configParameters(
                configParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enhancedVpcRouting(enhancedVpcRouting?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .publiclyAccessible(publiclyAccessible?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workgroupName(workgroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkgroupArgs].
 */
@PulumiTagMarker
public class WorkgroupArgsBuilder internal constructor() {
    private var baseCapacity: Output<Int>? = null

    private var configParameters: Output<List<WorkgroupConfigParameterArgs>>? = null

    private var enhancedVpcRouting: Output<Boolean>? = null

    private var namespaceName: Output<String>? = null

    private var publiclyAccessible: Output<Boolean>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workgroupName: Output<String>? = null

    /**
     * @param value The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
     */
    @JvmName("kbbpllcgtlvnghkg")
    public suspend fun baseCapacity(`value`: Output<Int>) {
        this.baseCapacity = value
    }

    /**
     * @param value An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    @JvmName("gatfuvuoohrdwpqs")
    public suspend fun configParameters(`value`: Output<List<WorkgroupConfigParameterArgs>>) {
        this.configParameters = value
    }

    @JvmName("ctliuwxludjdvfsk")
    public suspend fun configParameters(vararg values: Output<WorkgroupConfigParameterArgs>) {
        this.configParameters = Output.all(values.asList())
    }

    /**
     * @param values An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    @JvmName("numtiglsiqdtwuby")
    public suspend fun configParameters(values: List<Output<WorkgroupConfigParameterArgs>>) {
        this.configParameters = Output.all(values)
    }

    /**
     * @param value The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
     */
    @JvmName("aussoujabpekrbrt")
    public suspend fun enhancedVpcRouting(`value`: Output<Boolean>) {
        this.enhancedVpcRouting = value
    }

    /**
     * @param value The name of the namespace.
     */
    @JvmName("lxgmuyojtsmadrfl")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value A value that specifies whether the workgroup can be accessed from a public network.
     */
    @JvmName("apkhxuuanhhkxmcx")
    public suspend fun publiclyAccessible(`value`: Output<Boolean>) {
        this.publiclyAccessible = value
    }

    /**
     * @param value An array of security group IDs to associate with the workgroup.
     */
    @JvmName("rjdpfayxhjuyugtt")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("ilabksqhtnrrjrfi")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values An array of security group IDs to associate with the workgroup.
     */
    @JvmName("hijbtivoprqyoyrf")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
     */
    @JvmName("hosvaxcuvyhqtgiy")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("uixwgltctfswcuif")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
     */
    @JvmName("xfuwxkylbbbngoug")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pdfuntossjbrcqct")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the workgroup.
     * The following arguments are optional:
     */
    @JvmName("kaigloijgkliovlb")
    public suspend fun workgroupName(`value`: Output<String>) {
        this.workgroupName = value
    }

    /**
     * @param value The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
     */
    @JvmName("fvlqbqjetrutrjrq")
    public suspend fun baseCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseCapacity = mapped
    }

    /**
     * @param value An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    @JvmName("vatgvseirdpfutgp")
    public suspend fun configParameters(`value`: List<WorkgroupConfigParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configParameters = mapped
    }

    /**
     * @param argument An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    @JvmName("lyoakvnopbjoeyno")
    public suspend
    fun configParameters(argument: List<suspend WorkgroupConfigParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkgroupConfigParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configParameters = mapped
    }

    /**
     * @param argument An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    @JvmName("mdcnfyqwhgeqfmer")
    public suspend fun configParameters(
        vararg
        argument: suspend WorkgroupConfigParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WorkgroupConfigParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configParameters = mapped
    }

    /**
     * @param argument An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    @JvmName("nvkssjlpftoqqtxh")
    public suspend
    fun configParameters(argument: suspend WorkgroupConfigParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WorkgroupConfigParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configParameters = mapped
    }

    /**
     * @param values An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
     */
    @JvmName("qtvosntndkomnpfr")
    public suspend fun configParameters(vararg values: WorkgroupConfigParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configParameters = mapped
    }

    /**
     * @param value The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
     */
    @JvmName("icfhjocfdljiusek")
    public suspend fun enhancedVpcRouting(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enhancedVpcRouting = mapped
    }

    /**
     * @param value The name of the namespace.
     */
    @JvmName("aaqcejilogjkdygn")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value A value that specifies whether the workgroup can be accessed from a public network.
     */
    @JvmName("wolhsceyllcrysnu")
    public suspend fun publiclyAccessible(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publiclyAccessible = mapped
    }

    /**
     * @param value An array of security group IDs to associate with the workgroup.
     */
    @JvmName("hauylryeigvdihva")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values An array of security group IDs to associate with the workgroup.
     */
    @JvmName("ekjxulpjpuqugdiv")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
     */
    @JvmName("npjuhtgeiatjojkh")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
     */
    @JvmName("jlkflxfiajkqlfaj")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rtmvufxqqtshtqtr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ahscicsfkkymfjhs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the workgroup.
     * The following arguments are optional:
     */
    @JvmName("kbpfdximogwnpwek")
    public suspend fun workgroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workgroupName = mapped
    }

    internal fun build(): WorkgroupArgs = WorkgroupArgs(
        baseCapacity = baseCapacity,
        configParameters = configParameters,
        enhancedVpcRouting = enhancedVpcRouting,
        namespaceName = namespaceName,
        publiclyAccessible = publiclyAccessible,
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds,
        tags = tags,
        workgroupName = workgroupName,
    )
}
