@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin.inputs

import com.pulumi.aws.redshiftserverless.inputs.GetCredentialsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCredentials.
 * @property dbName The name of the database to get temporary authorization to log on to.
 * @property durationSeconds The number of seconds until the returned temporary password expires. The minimum is 900 seconds, and the maximum is 3600 seconds.
 * @property workgroupName The name of the workgroup associated with the database.
 */
public data class GetCredentialsPlainArgs(
    public val dbName: String? = null,
    public val durationSeconds: Int? = null,
    public val workgroupName: String,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.inputs.GetCredentialsPlainArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.inputs.GetCredentialsPlainArgs =
        com.pulumi.aws.redshiftserverless.inputs.GetCredentialsPlainArgs.builder()
            .dbName(dbName?.let({ args0 -> args0 }))
            .durationSeconds(durationSeconds?.let({ args0 -> args0 }))
            .workgroupName(workgroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCredentialsPlainArgs].
 */
@PulumiTagMarker
public class GetCredentialsPlainArgsBuilder internal constructor() {
    private var dbName: String? = null

    private var durationSeconds: Int? = null

    private var workgroupName: String? = null

    /**
     * @param value The name of the database to get temporary authorization to log on to.
     */
    @JvmName("svfoipihiksikuki")
    public suspend fun dbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbName = mapped
    }

    /**
     * @param value The number of seconds until the returned temporary password expires. The minimum is 900 seconds, and the maximum is 3600 seconds.
     */
    @JvmName("sawgkiooqwvjkthr")
    public suspend fun durationSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.durationSeconds = mapped
    }

    /**
     * @param value The name of the workgroup associated with the database.
     */
    @JvmName("hxmeuelbqqeompyy")
    public suspend fun workgroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workgroupName = mapped
    }

    internal fun build(): GetCredentialsPlainArgs = GetCredentialsPlainArgs(
        dbName = dbName,
        durationSeconds = durationSeconds,
        workgroupName = workgroupName ?: throw PulumiNullFieldException("workgroupName"),
    )
}
