@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin.inputs

import com.pulumi.aws.redshiftserverless.inputs.WorkgroupConfigParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property parameterKey The key of the parameter. The options are `auto_mv`, `datestyle`, `enable_case_sensitive_identifier`, `enable_user_activity_logging`, `query_group`, `search_path`, `require_ssl`, `use_fips_ssl`, and [query monitoring metrics](https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless) that let you define performance boundaries: `max_query_cpu_time`, `max_query_blocks_read`, `max_scan_row_count`, `max_query_execution_time`, `max_query_queue_time`, `max_query_cpu_usage_percent`, `max_query_temp_blocks_to_disk`, `max_join_row_count` and `max_nested_loop_join_row_count`.
 * @property parameterValue The value of the parameter to set.
 */
public data class WorkgroupConfigParameterArgs(
    public val parameterKey: Output<String>,
    public val parameterValue: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.redshiftserverless.inputs.WorkgroupConfigParameterArgs> {
    override fun toJava(): com.pulumi.aws.redshiftserverless.inputs.WorkgroupConfigParameterArgs =
        com.pulumi.aws.redshiftserverless.inputs.WorkgroupConfigParameterArgs.builder()
            .parameterKey(parameterKey.applyValue({ args0 -> args0 }))
            .parameterValue(parameterValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkgroupConfigParameterArgs].
 */
@PulumiTagMarker
public class WorkgroupConfigParameterArgsBuilder internal constructor() {
    private var parameterKey: Output<String>? = null

    private var parameterValue: Output<String>? = null

    /**
     * @param value The key of the parameter. The options are `auto_mv`, `datestyle`, `enable_case_sensitive_identifier`, `enable_user_activity_logging`, `query_group`, `search_path`, `require_ssl`, `use_fips_ssl`, and [query monitoring metrics](https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless) that let you define performance boundaries: `max_query_cpu_time`, `max_query_blocks_read`, `max_scan_row_count`, `max_query_execution_time`, `max_query_queue_time`, `max_query_cpu_usage_percent`, `max_query_temp_blocks_to_disk`, `max_join_row_count` and `max_nested_loop_join_row_count`.
     */
    @JvmName("emitdaoqswmwempk")
    public suspend fun parameterKey(`value`: Output<String>) {
        this.parameterKey = value
    }

    /**
     * @param value The value of the parameter to set.
     */
    @JvmName("yicvqbskagdneovm")
    public suspend fun parameterValue(`value`: Output<String>) {
        this.parameterValue = value
    }

    /**
     * @param value The key of the parameter. The options are `auto_mv`, `datestyle`, `enable_case_sensitive_identifier`, `enable_user_activity_logging`, `query_group`, `search_path`, `require_ssl`, `use_fips_ssl`, and [query monitoring metrics](https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless) that let you define performance boundaries: `max_query_cpu_time`, `max_query_blocks_read`, `max_scan_row_count`, `max_query_execution_time`, `max_query_queue_time`, `max_query_cpu_usage_percent`, `max_query_temp_blocks_to_disk`, `max_join_row_count` and `max_nested_loop_join_row_count`.
     */
    @JvmName("gxcwrkkukritbpsm")
    public suspend fun parameterKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterKey = mapped
    }

    /**
     * @param value The value of the parameter to set.
     */
    @JvmName("msfeysfsispibrjb")
    public suspend fun parameterValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterValue = mapped
    }

    internal fun build(): WorkgroupConfigParameterArgs = WorkgroupConfigParameterArgs(
        parameterKey = parameterKey ?: throw PulumiNullFieldException("parameterKey"),
        parameterValue = parameterValue ?: throw PulumiNullFieldException("parameterValue"),
    )
}
