@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property availabilityZone The availability Zone.
 * @property networkInterfaceId The unique identifier of the network interface.
 * @property privateIpAddress The IPv4 address of the network interface within the subnet.
 * @property subnetId The unique identifier of the subnet.
 */
public data class EndpointAccessVpcEndpointNetworkInterface(
    public val availabilityZone: String? = null,
    public val networkInterfaceId: String? = null,
    public val privateIpAddress: String? = null,
    public val subnetId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.redshiftserverless.outputs.EndpointAccessVpcEndpointNetworkInterface):
            EndpointAccessVpcEndpointNetworkInterface = EndpointAccessVpcEndpointNetworkInterface(
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            networkInterfaceId = javaType.networkInterfaceId().map({ args0 -> args0 }).orElse(null),
            privateIpAddress = javaType.privateIpAddress().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
