@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property address The DNS address of the VPC endpoint.
 * @property port The port that Amazon Redshift Serverless listens on.
 * @property vpcEndpoints The VPC endpoint or the Redshift Serverless workgroup. See `VPC Endpoint` below.
 */
public data class GetWorkgroupEndpoint(
    public val address: String,
    public val port: Int,
    public val vpcEndpoints: List<GetWorkgroupEndpointVpcEndpoint>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshiftserverless.outputs.GetWorkgroupEndpoint):
            GetWorkgroupEndpoint = GetWorkgroupEndpoint(
            address = javaType.address(),
            port = javaType.port(),
            vpcEndpoints = javaType.vpcEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.redshiftserverless.kotlin.outputs.GetWorkgroupEndpointVpcEndpoint.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
