@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.redshiftserverless.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property address The DNS address of the VPC endpoint.
 * @property port The port that Amazon Redshift Serverless listens on.
 * @property vpcEndpoints The VPC endpoint or the Redshift Serverless workgroup. See `VPC Endpoint` below.
 */
public data class WorkgroupEndpoint(
    public val address: String? = null,
    public val port: Int? = null,
    public val vpcEndpoints: List<WorkgroupEndpointVpcEndpoint>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.redshiftserverless.outputs.WorkgroupEndpoint):
            WorkgroupEndpoint = WorkgroupEndpoint(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            vpcEndpoints = javaType.vpcEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.redshiftserverless.kotlin.outputs.WorkgroupEndpointVpcEndpoint.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
