@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourceexplorer.kotlin

import com.pulumi.aws.resourceexplorer.kotlin.outputs.IndexTimeouts
import com.pulumi.aws.resourceexplorer.kotlin.outputs.IndexTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Index].
 */
@PulumiTagMarker
public class IndexResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IndexArgs = IndexArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IndexArgsBuilder.() -> Unit) {
        val builder = IndexArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Index {
        val builtJavaResource = com.pulumi.aws.resourceexplorer.Index(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Index(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a Resource Explorer index in the current AWS Region.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.resourceexplorer.Index;
 * import com.pulumi.aws.resourceexplorer.IndexArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Index("example", IndexArgs.builder()
 *             .type("LOCAL")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Resource Explorer indexes using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:resourceexplorer/index:Index example arn:aws:resource-explorer-2:us-east-1:123456789012:index/6047ac4e-207e-4487-9bcf-cb53bb0ff5cc
 * ```
 *
 */
public class Index internal constructor(
    override val javaResource: com.pulumi.aws.resourceexplorer.Index,
) : KotlinCustomResource(javaResource, IndexMapper) {
    /**
     * Amazon Resource Name (ARN) of the Resource Explorer index.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<IndexTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of the index. Valid values: `AGGREGATOR`, `LOCAL`. To understand the difference between `LOCAL` and `AGGREGATOR`, see the [_AWS Resource Explorer User Guide_](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html).
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IndexMapper : ResourceMapper<Index> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.resourceexplorer.Index::class == javaResource::class

    override fun map(javaResource: Resource): Index = Index(
        javaResource as
            com.pulumi.aws.resourceexplorer.Index,
    )
}

/**
 * @see [Index].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Index].
 */
public suspend fun index(name: String, block: suspend IndexResourceBuilder.() -> Unit): Index {
    val builder = IndexResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Index].
 * @param name The _unique_ name of the resulting resource.
 */
public fun index(name: String): Index {
    val builder = IndexResourceBuilder()
    builder.name(name)
    return builder.build()
}
