@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourceexplorer.kotlin

import com.pulumi.aws.resourceexplorer.ViewArgs.builder
import com.pulumi.aws.resourceexplorer.kotlin.inputs.ViewFiltersArgs
import com.pulumi.aws.resourceexplorer.kotlin.inputs.ViewFiltersArgsBuilder
import com.pulumi.aws.resourceexplorer.kotlin.inputs.ViewIncludedPropertyArgs
import com.pulumi.aws.resourceexplorer.kotlin.inputs.ViewIncludedPropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a Resource Explorer view.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.resourceexplorer.Index;
 * import com.pulumi.aws.resourceexplorer.IndexArgs;
 * import com.pulumi.aws.resourceexplorer.View;
 * import com.pulumi.aws.resourceexplorer.ViewArgs;
 * import com.pulumi.aws.resourceexplorer.inputs.ViewFiltersArgs;
 * import com.pulumi.aws.resourceexplorer.inputs.ViewIncludedPropertyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleIndex = new Index("exampleIndex", IndexArgs.builder()
 *             .type("LOCAL")
 *             .build());
 *         var exampleView = new View("exampleView", ViewArgs.builder()
 *             .filters(ViewFiltersArgs.builder()
 *                 .filterString("resourcetype:ec2:instance")
 *                 .build())
 *             .includedProperties(ViewIncludedPropertyArgs.builder()
 *                 .name("tags")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleIndex)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Resource Explorer views using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:resourceexplorer/view:View example arn:aws:resource-explorer-2:us-west-2:123456789012:view/exampleview/e0914f6c-6c27-4b47-b5d4-6b28381a2421
 * ```
 * @property defaultView Specifies whether the view is the [_default view_](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views-about.html#manage-views-about-default) for the AWS Region. Default: `false`.
 * @property filters Specifies which resources are included in the results of queries made using this view. See Filters below for more details.
 * @property includedProperties Optional fields to be included in search results from this view. See Included Properties below for more details.
 * @property name The name of the view. The name must be no more than 64 characters long, and can include letters, digits, and the dash (-) character. The name must be unique within its AWS Region.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ViewArgs(
    public val defaultView: Output<Boolean>? = null,
    public val filters: Output<ViewFiltersArgs>? = null,
    public val includedProperties: Output<List<ViewIncludedPropertyArgs>>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.resourceexplorer.ViewArgs> {
    override fun toJava(): com.pulumi.aws.resourceexplorer.ViewArgs =
        com.pulumi.aws.resourceexplorer.ViewArgs.builder()
            .defaultView(defaultView?.applyValue({ args0 -> args0 }))
            .filters(filters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .includedProperties(
                includedProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ViewArgs].
 */
@PulumiTagMarker
public class ViewArgsBuilder internal constructor() {
    private var defaultView: Output<Boolean>? = null

    private var filters: Output<ViewFiltersArgs>? = null

    private var includedProperties: Output<List<ViewIncludedPropertyArgs>>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies whether the view is the [_default view_](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views-about.html#manage-views-about-default) for the AWS Region. Default: `false`.
     */
    @JvmName("htnmknmsbpmjjxds")
    public suspend fun defaultView(`value`: Output<Boolean>) {
        this.defaultView = value
    }

    /**
     * @param value Specifies which resources are included in the results of queries made using this view. See Filters below for more details.
     */
    @JvmName("vbbrbllsosucqmvt")
    public suspend fun filters(`value`: Output<ViewFiltersArgs>) {
        this.filters = value
    }

    /**
     * @param value Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    @JvmName("cftimvooqxpemhcr")
    public suspend fun includedProperties(`value`: Output<List<ViewIncludedPropertyArgs>>) {
        this.includedProperties = value
    }

    @JvmName("bdqmtpfoxmkfauxb")
    public suspend fun includedProperties(vararg values: Output<ViewIncludedPropertyArgs>) {
        this.includedProperties = Output.all(values.asList())
    }

    /**
     * @param values Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    @JvmName("nnvtkbkeyhbirpwj")
    public suspend fun includedProperties(values: List<Output<ViewIncludedPropertyArgs>>) {
        this.includedProperties = Output.all(values)
    }

    /**
     * @param value The name of the view. The name must be no more than 64 characters long, and can include letters, digits, and the dash (-) character. The name must be unique within its AWS Region.
     */
    @JvmName("lmgrfdllynmvdrbl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kcedfpanodlbdgul")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies whether the view is the [_default view_](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views-about.html#manage-views-about-default) for the AWS Region. Default: `false`.
     */
    @JvmName("tnokgtadmdgfrxff")
    public suspend fun defaultView(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultView = mapped
    }

    /**
     * @param value Specifies which resources are included in the results of queries made using this view. See Filters below for more details.
     */
    @JvmName("tmyxvhxnpfeogbmp")
    public suspend fun filters(`value`: ViewFiltersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument Specifies which resources are included in the results of queries made using this view. See Filters below for more details.
     */
    @JvmName("qysrvqifvnhqvxjn")
    public suspend fun filters(argument: suspend ViewFiltersArgsBuilder.() -> Unit) {
        val toBeMapped = ViewFiltersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param value Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    @JvmName("tkxnrccpcilafmut")
    public suspend fun includedProperties(`value`: List<ViewIncludedPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedProperties = mapped
    }

    /**
     * @param argument Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    @JvmName("khnewakemmxyhsvj")
    public suspend
    fun includedProperties(argument: List<suspend ViewIncludedPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ViewIncludedPropertyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.includedProperties = mapped
    }

    /**
     * @param argument Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    @JvmName("mitlfyuluglsbday")
    public suspend fun includedProperties(
        vararg
        argument: suspend ViewIncludedPropertyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ViewIncludedPropertyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.includedProperties = mapped
    }

    /**
     * @param argument Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    @JvmName("ilmddkmoylmblrqe")
    public suspend
    fun includedProperties(argument: suspend ViewIncludedPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ViewIncludedPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.includedProperties = mapped
    }

    /**
     * @param values Optional fields to be included in search results from this view. See Included Properties below for more details.
     */
    @JvmName("jbtbuqbshcofjxun")
    public suspend fun includedProperties(vararg values: ViewIncludedPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedProperties = mapped
    }

    /**
     * @param value The name of the view. The name must be no more than 64 characters long, and can include letters, digits, and the dash (-) character. The name must be unique within its AWS Region.
     */
    @JvmName("ebtjxphavayvyejb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ymmkllaeiabxbvcv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nuawwcdqybolgeku")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ViewArgs = ViewArgs(
        defaultView = defaultView,
        filters = filters,
        includedProperties = includedProperties,
        name = name,
        tags = tags,
    )
}
