@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourceexplorer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property filterString The string that contains the search keywords, prefixes, and operators to control the results that can be returned by a search operation. For more details, see [Search query syntax](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html).
 */
public data class ViewFilters(
    public val filterString: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.resourceexplorer.outputs.ViewFilters): ViewFilters =
            ViewFilters(
                filterString = javaType.filterString(),
            )
    }
}
