@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroups.kotlin

import com.pulumi.aws.resourcegroups.GroupArgs.builder
import com.pulumi.aws.resourcegroups.kotlin.inputs.GroupConfigurationArgs
import com.pulumi.aws.resourcegroups.kotlin.inputs.GroupConfigurationArgsBuilder
import com.pulumi.aws.resourcegroups.kotlin.inputs.GroupResourceQueryArgs
import com.pulumi.aws.resourcegroups.kotlin.inputs.GroupResourceQueryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Resource Group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.resourcegroups.Group;
 * import com.pulumi.aws.resourcegroups.GroupArgs;
 * import com.pulumi.aws.resourcegroups.inputs.GroupResourceQueryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Group("test", GroupArgs.builder()
 *             .resourceQuery(GroupResourceQueryArgs.builder()
 *                 .query("""
 * {
 *   "ResourceTypeFilters": [
 *     "AWS::EC2::Instance"
 *   ],
 *   "TagFilters": [
 *     {
 *       "Key": "Stage",
 *       "Values": ["Test"]
 *     }
 *   ]
 * }
 *                 """)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import resource groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:resourcegroups/group:Group foo resource-group-name
 * ```
 * @property configurations A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
 * @property description A description of the resource group.
 * @property name The resource group's name. A resource group name can have a maximum of 127 characters, including letters, numbers, hyphens, dots, and underscores. The name cannot start with `AWS` or `aws`.
 * @property resourceQuery A `resource_query` block. Resource queries are documented below.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class GroupArgs(
    public val configurations: Output<List<GroupConfigurationArgs>>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceQuery: Output<GroupResourceQueryArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.resourcegroups.GroupArgs> {
    override fun toJava(): com.pulumi.aws.resourcegroups.GroupArgs =
        com.pulumi.aws.resourcegroups.GroupArgs.builder()
            .configurations(
                configurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceQuery(resourceQuery?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var configurations: Output<List<GroupConfigurationArgs>>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceQuery: Output<GroupResourceQueryArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
     */
    @JvmName("lftuwnwttsdyxulk")
    public suspend fun configurations(`value`: Output<List<GroupConfigurationArgs>>) {
        this.configurations = value
    }

    @JvmName("uspnwowlfidqmdvy")
    public suspend fun configurations(vararg values: Output<GroupConfigurationArgs>) {
        this.configurations = Output.all(values.asList())
    }

    /**
     * @param values A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
     */
    @JvmName("cfymlveykbdpyjfa")
    public suspend fun configurations(values: List<Output<GroupConfigurationArgs>>) {
        this.configurations = Output.all(values)
    }

    /**
     * @param value A description of the resource group.
     */
    @JvmName("edtidrwithipcotw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The resource group's name. A resource group name can have a maximum of 127 characters, including letters, numbers, hyphens, dots, and underscores. The name cannot start with `AWS` or `aws`.
     */
    @JvmName("mxddngtpdakhspcc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A `resource_query` block. Resource queries are documented below.
     */
    @JvmName("papndcffhfqbdvje")
    public suspend fun resourceQuery(`value`: Output<GroupResourceQueryArgs>) {
        this.resourceQuery = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gsjdaltmcundtheq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
     */
    @JvmName("agvkefxopgiewyuk")
    public suspend fun configurations(`value`: List<GroupConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param argument A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
     */
    @JvmName("icherojxpwjojibd")
    public suspend
    fun configurations(argument: List<suspend GroupConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GroupConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
     */
    @JvmName("wpdishofiulajsbl")
    public suspend fun configurations(
        vararg
        argument: suspend GroupConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GroupConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
     */
    @JvmName("xfhklingnpdckavv")
    public suspend fun configurations(argument: suspend GroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GroupConfigurationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param values A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. See below for details.
     */
    @JvmName("wgpoounxhjeeownh")
    public suspend fun configurations(vararg values: GroupConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param value A description of the resource group.
     */
    @JvmName("fteivagbgrgpkeen")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The resource group's name. A resource group name can have a maximum of 127 characters, including letters, numbers, hyphens, dots, and underscores. The name cannot start with `AWS` or `aws`.
     */
    @JvmName("elwdtrclwrkfdxrm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A `resource_query` block. Resource queries are documented below.
     */
    @JvmName("gbousdyqurdnfpum")
    public suspend fun resourceQuery(`value`: GroupResourceQueryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceQuery = mapped
    }

    /**
     * @param argument A `resource_query` block. Resource queries are documented below.
     */
    @JvmName("wmbodaankipdagdc")
    public suspend fun resourceQuery(argument: suspend GroupResourceQueryArgsBuilder.() -> Unit) {
        val toBeMapped = GroupResourceQueryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceQuery = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vqmklmypwhhqowqf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fqnwmlpgkgshqqoo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        configurations = configurations,
        description = description,
        name = name,
        resourceQuery = resourceQuery,
        tags = tags,
    )
}
