@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroups.kotlin

import com.pulumi.aws.resourcegroups.ResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Resource Groups Resource.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DedicatedHost;
 * import com.pulumi.aws.ec2.DedicatedHostArgs;
 * import com.pulumi.aws.resourcegroups.Group;
 * import com.pulumi.aws.resourcegroups.Resource;
 * import com.pulumi.aws.resourcegroups.ResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDedicatedHost = new DedicatedHost("exampleDedicatedHost", DedicatedHostArgs.builder()
 *             .instanceFamily("t3")
 *             .availabilityZone("us-east-1a")
 *             .hostRecovery("off")
 *             .autoPlacement("on")
 *             .build());
 *         var exampleGroup = new Group("exampleGroup");
 *         var exampleResource = new Resource("exampleResource", ResourceArgs.builder()
 *             .groupArn(exampleGroup.arn())
 *             .resourceArn(exampleDedicatedHost.arn())
 *             .build());
 *     }
 * }
 * ```
 * @property groupArn The name or the ARN of the resource group to add resources to.
 * The following arguments are optional:
 * @property resourceArn The ARN of the resource to be added to the group.
 */
public data class ResourceArgs(
    public val groupArn: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.resourcegroups.ResourceArgs> {
    override fun toJava(): com.pulumi.aws.resourcegroups.ResourceArgs =
        com.pulumi.aws.resourcegroups.ResourceArgs.builder()
            .groupArn(groupArn?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceArgs].
 */
@PulumiTagMarker
public class ResourceArgsBuilder internal constructor() {
    private var groupArn: Output<String>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value The name or the ARN of the resource group to add resources to.
     * The following arguments are optional:
     */
    @JvmName("mnmtpxmnrnuvdgws")
    public suspend fun groupArn(`value`: Output<String>) {
        this.groupArn = value
    }

    /**
     * @param value The ARN of the resource to be added to the group.
     */
    @JvmName("scyscrcudfrkctub")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The name or the ARN of the resource group to add resources to.
     * The following arguments are optional:
     */
    @JvmName("ysajpkmlwwdmbwxf")
    public suspend fun groupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupArn = mapped
    }

    /**
     * @param value The ARN of the resource to be added to the group.
     */
    @JvmName("xpjtsvtsvnhvpjvm")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): ResourceArgs = ResourceArgs(
        groupArn = groupArn,
        resourceArn = resourceArn,
    )
}
