@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroups.kotlin.inputs

import com.pulumi.aws.resourcegroups.inputs.GroupConfigurationParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the group configuration parameter.
 * @property values The value or values to be used for the specified parameter.
 */
public data class GroupConfigurationParameterArgs(
    public val name: Output<String>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.resourcegroups.inputs.GroupConfigurationParameterArgs> {
    override fun toJava(): com.pulumi.aws.resourcegroups.inputs.GroupConfigurationParameterArgs =
        com.pulumi.aws.resourcegroups.inputs.GroupConfigurationParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GroupConfigurationParameterArgs].
 */
@PulumiTagMarker
public class GroupConfigurationParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The name of the group configuration parameter.
     */
    @JvmName("dsniklelofieqhvh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value or values to be used for the specified parameter.
     */
    @JvmName("aydwwotpdqonjyic")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("qnwufkjqcwhtsvrn")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The value or values to be used for the specified parameter.
     */
    @JvmName("qqcrjturscctqqam")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The name of the group configuration parameter.
     */
    @JvmName("fcfxnwxbvhyumngk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value or values to be used for the specified parameter.
     */
    @JvmName("gwuhdqujcjaobyqu")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The value or values to be used for the specified parameter.
     */
    @JvmName("rponroqwaajhcaft")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): GroupConfigurationParameterArgs = GroupConfigurationParameterArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
