@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroups.kotlin.inputs

import com.pulumi.aws.resourcegroups.inputs.GroupResourceQueryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property query The resource query as a JSON string.
 * @property type The type of the resource query. Defaults to `TAG_FILTERS_1_0`.
 */
public data class GroupResourceQueryArgs(
    public val query: Output<String>,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.resourcegroups.inputs.GroupResourceQueryArgs> {
    override fun toJava(): com.pulumi.aws.resourcegroups.inputs.GroupResourceQueryArgs =
        com.pulumi.aws.resourcegroups.inputs.GroupResourceQueryArgs.builder()
            .query(query.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupResourceQueryArgs].
 */
@PulumiTagMarker
public class GroupResourceQueryArgsBuilder internal constructor() {
    private var query: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The resource query as a JSON string.
     */
    @JvmName("xexjpsrhrpgjmsot")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value The type of the resource query. Defaults to `TAG_FILTERS_1_0`.
     */
    @JvmName("jexutlblisisnyrb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The resource query as a JSON string.
     */
    @JvmName("tbeyhsfhwykjllar")
    public suspend fun query(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value The type of the resource query. Defaults to `TAG_FILTERS_1_0`.
     */
    @JvmName("rmcvejsstbpjflnr")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): GroupResourceQueryArgs = GroupResourceQueryArgs(
        query = query ?: throw PulumiNullFieldException("query"),
        type = type,
    )
}
