@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroups.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name The name of the group configuration parameter.
 * @property values The value or values to be used for the specified parameter.
 */
public data class GroupConfigurationParameter(
    public val name: String,
    public val values: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.resourcegroups.outputs.GroupConfigurationParameter):
            GroupConfigurationParameter = GroupConfigurationParameter(
            name = javaType.name(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
