@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroups.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property query The resource query as a JSON string.
 * @property type The type of the resource query. Defaults to `TAG_FILTERS_1_0`.
 */
public data class GroupResourceQuery(
    public val query: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.resourcegroups.outputs.GroupResourceQuery):
            GroupResourceQuery = GroupResourceQuery(
            query = javaType.query(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
