@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroupstaggingapi.kotlin.inputs

import com.pulumi.aws.resourcegroupstaggingapi.inputs.GetResourcesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResources.
 * @property excludeCompliantResources Specifies whether to exclude resources that are compliant with the tag policy. You can use this parameter only if the `include_compliance_details` argument is also set to `true`.
 * @property includeComplianceDetails Specifies whether to include details regarding the compliance with the effective tag policy.
 * @property resourceArnLists Specifies a list of ARNs of resources for which you want to retrieve tag data. Conflicts with `filter`.
 * @property resourceTypeFilters Constraints on the resources that you want returned. The format of each resource type is `service:resourceType`. For example, specifying a resource type of `ec2` returns all Amazon EC2 resources (which includes EC2 instances). Specifying a resource type of `ec2:instance` returns only EC2 instances.
 * @property tagFilters Specifies a list of Tag Filters (keys and values) to restrict the output to only those resources that have the specified tag and, if included, the specified value. See Tag Filter below. Conflicts with `resource_arn_list`.
 */
public data class GetResourcesPlainArgs(
    public val excludeCompliantResources: Boolean? = null,
    public val includeComplianceDetails: Boolean? = null,
    public val resourceArnLists: List<String>? = null,
    public val resourceTypeFilters: List<String>? = null,
    public val tagFilters: List<GetResourcesTagFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.resourcegroupstaggingapi.inputs.GetResourcesPlainArgs> {
    override fun toJava(): com.pulumi.aws.resourcegroupstaggingapi.inputs.GetResourcesPlainArgs =
        com.pulumi.aws.resourcegroupstaggingapi.inputs.GetResourcesPlainArgs.builder()
            .excludeCompliantResources(excludeCompliantResources?.let({ args0 -> args0 }))
            .includeComplianceDetails(includeComplianceDetails?.let({ args0 -> args0 }))
            .resourceArnLists(resourceArnLists?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceTypeFilters(resourceTypeFilters?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .tagFilters(
                tagFilters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetResourcesPlainArgs].
 */
@PulumiTagMarker
public class GetResourcesPlainArgsBuilder internal constructor() {
    private var excludeCompliantResources: Boolean? = null

    private var includeComplianceDetails: Boolean? = null

    private var resourceArnLists: List<String>? = null

    private var resourceTypeFilters: List<String>? = null

    private var tagFilters: List<GetResourcesTagFilter>? = null

    /**
     * @param value Specifies whether to exclude resources that are compliant with the tag policy. You can use this parameter only if the `include_compliance_details` argument is also set to `true`.
     */
    @JvmName("odokobxonmkogwgm")
    public suspend fun excludeCompliantResources(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.excludeCompliantResources = mapped
    }

    /**
     * @param value Specifies whether to include details regarding the compliance with the effective tag policy.
     */
    @JvmName("umaceksubwqrmspp")
    public suspend fun includeComplianceDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeComplianceDetails = mapped
    }

    /**
     * @param value Specifies a list of ARNs of resources for which you want to retrieve tag data. Conflicts with `filter`.
     */
    @JvmName("kgmkbhbbcbioduoa")
    public suspend fun resourceArnLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceArnLists = mapped
    }

    /**
     * @param values Specifies a list of ARNs of resources for which you want to retrieve tag data. Conflicts with `filter`.
     */
    @JvmName("dqlgadcthcqcryxs")
    public suspend fun resourceArnLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceArnLists = mapped
    }

    /**
     * @param value Constraints on the resources that you want returned. The format of each resource type is `service:resourceType`. For example, specifying a resource type of `ec2` returns all Amazon EC2 resources (which includes EC2 instances). Specifying a resource type of `ec2:instance` returns only EC2 instances.
     */
    @JvmName("mhphpglscuhwjxnb")
    public suspend fun resourceTypeFilters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceTypeFilters = mapped
    }

    /**
     * @param values Constraints on the resources that you want returned. The format of each resource type is `service:resourceType`. For example, specifying a resource type of `ec2` returns all Amazon EC2 resources (which includes EC2 instances). Specifying a resource type of `ec2:instance` returns only EC2 instances.
     */
    @JvmName("lcxxryeuiekfitba")
    public suspend fun resourceTypeFilters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceTypeFilters = mapped
    }

    /**
     * @param value Specifies a list of Tag Filters (keys and values) to restrict the output to only those resources that have the specified tag and, if included, the specified value. See Tag Filter below. Conflicts with `resource_arn_list`.
     */
    @JvmName("bnrjpigorpdljiea")
    public suspend fun tagFilters(`value`: List<GetResourcesTagFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tagFilters = mapped
    }

    /**
     * @param argument Specifies a list of Tag Filters (keys and values) to restrict the output to only those resources that have the specified tag and, if included, the specified value. See Tag Filter below. Conflicts with `resource_arn_list`.
     */
    @JvmName("gkdxhsrwfutsxtxi")
    public suspend fun tagFilters(argument: List<suspend GetResourcesTagFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetResourcesTagFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.tagFilters = mapped
    }

    /**
     * @param argument Specifies a list of Tag Filters (keys and values) to restrict the output to only those resources that have the specified tag and, if included, the specified value. See Tag Filter below. Conflicts with `resource_arn_list`.
     */
    @JvmName("ghomlpbinjefrmne")
    public suspend fun tagFilters(vararg argument: suspend GetResourcesTagFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetResourcesTagFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.tagFilters = mapped
    }

    /**
     * @param argument Specifies a list of Tag Filters (keys and values) to restrict the output to only those resources that have the specified tag and, if included, the specified value. See Tag Filter below. Conflicts with `resource_arn_list`.
     */
    @JvmName("lhfovefxvcxrvoul")
    public suspend fun tagFilters(argument: suspend GetResourcesTagFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetResourcesTagFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.tagFilters = mapped
    }

    /**
     * @param values Specifies a list of Tag Filters (keys and values) to restrict the output to only those resources that have the specified tag and, if included, the specified value. See Tag Filter below. Conflicts with `resource_arn_list`.
     */
    @JvmName("pdeoaanjncbcicgr")
    public suspend fun tagFilters(vararg values: GetResourcesTagFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tagFilters = mapped
    }

    internal fun build(): GetResourcesPlainArgs = GetResourcesPlainArgs(
        excludeCompliantResources = excludeCompliantResources,
        includeComplianceDetails = includeComplianceDetails,
        resourceArnLists = resourceArnLists,
        resourceTypeFilters = resourceTypeFilters,
        tagFilters = tagFilters,
    )
}
