@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.resourcegroupstaggingapi.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getResources.
 * @property excludeCompliantResources
 * @property id The provider-assigned unique ID for this managed resource.
 * @property includeComplianceDetails
 * @property resourceArnLists
 * @property resourceTagMappingLists List of objects matching the search criteria.
 * @property resourceTypeFilters
 * @property tagFilters
 */
public data class GetResourcesResult(
    public val excludeCompliantResources: Boolean? = null,
    public val id: String,
    public val includeComplianceDetails: Boolean? = null,
    public val resourceArnLists: List<String>? = null,
    public val resourceTagMappingLists: List<GetResourcesResourceTagMappingList>,
    public val resourceTypeFilters: List<String>? = null,
    public val tagFilters: List<GetResourcesTagFilter>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.resourcegroupstaggingapi.outputs.GetResourcesResult):
            GetResourcesResult = GetResourcesResult(
            excludeCompliantResources = javaType.excludeCompliantResources().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            includeComplianceDetails = javaType.includeComplianceDetails().map({ args0 -> args0 }).orElse(null),
            resourceArnLists = javaType.resourceArnLists().map({ args0 -> args0 }),
            resourceTagMappingLists = javaType.resourceTagMappingLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.resourcegroupstaggingapi.kotlin.outputs.GetResourcesResourceTagMappingList.Companion.toKotlin(args0)
                })
            }),
            resourceTypeFilters = javaType.resourceTypeFilters().map({ args0 -> args0 }),
            tagFilters = javaType.tagFilters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.resourcegroupstaggingapi.kotlin.outputs.GetResourcesTagFilter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
