@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rolesanywhere.kotlin

import com.pulumi.aws.rolesanywhere.ProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a Roles Anywhere Profile.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.rolesanywhere.Profile;
 * import com.pulumi.aws.rolesanywhere.ProfileArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .path("/")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray(
 *                             "sts:AssumeRole",
 *                             "sts:TagSession",
 *                             "sts:SetSourceIdentity"
 *                         )),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "rolesanywhere.amazonaws.com")
 *                         )),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", "")
 *                     )))
 *                 )))
 *             .build());
 *         var testProfile = new Profile("testProfile", ProfileArgs.builder()
 *             .roleArns(testRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_rolesanywhere_profile` using its `id`. For example:
 * ```sh
 *  $ pulumi import aws:rolesanywhere/profile:Profile example db138a85-8925-4f9f-a409-08231233cacf
 * ```
 * @property durationSeconds The number of seconds the vended session credentials are valid for. Defaults to 3600.
 * @property enabled Whether or not the Profile is enabled.
 * @property managedPolicyArns A list of managed policy ARNs that apply to the vended session credentials.
 * @property name The name of the Profile.
 * @property requireInstanceProperties Specifies whether instance properties are required in [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests with this profile.
 * @property roleArns A list of IAM roles that this profile can assume
 * @property sessionPolicy A session policy that applies to the trust boundary of the vended session credentials.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ProfileArgs(
    public val durationSeconds: Output<Int>? = null,
    public val enabled: Output<Boolean>? = null,
    public val managedPolicyArns: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val requireInstanceProperties: Output<Boolean>? = null,
    public val roleArns: Output<List<String>>? = null,
    public val sessionPolicy: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rolesanywhere.ProfileArgs> {
    override fun toJava(): com.pulumi.aws.rolesanywhere.ProfileArgs =
        com.pulumi.aws.rolesanywhere.ProfileArgs.builder()
            .durationSeconds(durationSeconds?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .managedPolicyArns(managedPolicyArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .requireInstanceProperties(requireInstanceProperties?.applyValue({ args0 -> args0 }))
            .roleArns(roleArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sessionPolicy(sessionPolicy?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProfileArgs].
 */
@PulumiTagMarker
public class ProfileArgsBuilder internal constructor() {
    private var durationSeconds: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    private var managedPolicyArns: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var requireInstanceProperties: Output<Boolean>? = null

    private var roleArns: Output<List<String>>? = null

    private var sessionPolicy: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The number of seconds the vended session credentials are valid for. Defaults to 3600.
     */
    @JvmName("rkqkocixgtrseney")
    public suspend fun durationSeconds(`value`: Output<Int>) {
        this.durationSeconds = value
    }

    /**
     * @param value Whether or not the Profile is enabled.
     */
    @JvmName("ycofpewmjkgnxpak")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A list of managed policy ARNs that apply to the vended session credentials.
     */
    @JvmName("rbkeksobbypyumaq")
    public suspend fun managedPolicyArns(`value`: Output<List<String>>) {
        this.managedPolicyArns = value
    }

    @JvmName("opvgywhyguiivexl")
    public suspend fun managedPolicyArns(vararg values: Output<String>) {
        this.managedPolicyArns = Output.all(values.asList())
    }

    /**
     * @param values A list of managed policy ARNs that apply to the vended session credentials.
     */
    @JvmName("dvupuhcdnsmsycma")
    public suspend fun managedPolicyArns(values: List<Output<String>>) {
        this.managedPolicyArns = Output.all(values)
    }

    /**
     * @param value The name of the Profile.
     */
    @JvmName("hqvhslgshupwxsib")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies whether instance properties are required in [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests with this profile.
     */
    @JvmName("klhiwrgscvvppyrc")
    public suspend fun requireInstanceProperties(`value`: Output<Boolean>) {
        this.requireInstanceProperties = value
    }

    /**
     * @param value A list of IAM roles that this profile can assume
     */
    @JvmName("yuxusfnvdxdthbyn")
    public suspend fun roleArns(`value`: Output<List<String>>) {
        this.roleArns = value
    }

    @JvmName("mnbxprjhfrpfcdvw")
    public suspend fun roleArns(vararg values: Output<String>) {
        this.roleArns = Output.all(values.asList())
    }

    /**
     * @param values A list of IAM roles that this profile can assume
     */
    @JvmName("edyydeqalpqkbqwj")
    public suspend fun roleArns(values: List<Output<String>>) {
        this.roleArns = Output.all(values)
    }

    /**
     * @param value A session policy that applies to the trust boundary of the vended session credentials.
     */
    @JvmName("cmfucostrbotbjul")
    public suspend fun sessionPolicy(`value`: Output<String>) {
        this.sessionPolicy = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jpmrxiomxnnnikoh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The number of seconds the vended session credentials are valid for. Defaults to 3600.
     */
    @JvmName("anyqsifehcydoall")
    public suspend fun durationSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.durationSeconds = mapped
    }

    /**
     * @param value Whether or not the Profile is enabled.
     */
    @JvmName("pewhtgcpdwadndrt")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A list of managed policy ARNs that apply to the vended session credentials.
     */
    @JvmName("nrnoalyiaisgajuh")
    public suspend fun managedPolicyArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedPolicyArns = mapped
    }

    /**
     * @param values A list of managed policy ARNs that apply to the vended session credentials.
     */
    @JvmName("fuqhoqvjsbdcnrug")
    public suspend fun managedPolicyArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedPolicyArns = mapped
    }

    /**
     * @param value The name of the Profile.
     */
    @JvmName("bpyechxdwbkrsnqr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies whether instance properties are required in [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateSession.html) requests with this profile.
     */
    @JvmName("yirbbopgbjuvhtin")
    public suspend fun requireInstanceProperties(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireInstanceProperties = mapped
    }

    /**
     * @param value A list of IAM roles that this profile can assume
     */
    @JvmName("dcfeldibispukgxf")
    public suspend fun roleArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArns = mapped
    }

    /**
     * @param values A list of IAM roles that this profile can assume
     */
    @JvmName("tpwaglqabiwgicou")
    public suspend fun roleArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArns = mapped
    }

    /**
     * @param value A session policy that applies to the trust boundary of the vended session credentials.
     */
    @JvmName("xmstsjwegnydqvqq")
    public suspend fun sessionPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionPolicy = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vgykxefkuwcwtjlv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rijbfxygqypsbryp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProfileArgs = ProfileArgs(
        durationSeconds = durationSeconds,
        enabled = enabled,
        managedPolicyArns = managedPolicyArns,
        name = name,
        requireInstanceProperties = requireInstanceProperties,
        roleArns = roleArns,
        sessionPolicy = sessionPolicy,
        tags = tags,
    )
}
